/*
 * Decompiled with CFR 0.152.
 */
package caseine.mutants;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class Generate {
    private static Logger log = Logger.getLogger(Generate.class.getName());
    private static final String PATH_SRC = File.separator + "src";
    private static final String PATH_TEST = File.separator + "test";
    private static Options options = new Options();

    public static void main(String[] args) throws Exception {
        String className;
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        String projectPath = ".";
        int numberOfMutants = 10;
        String[] remainingArgs = cmd.getArgs();
        if (remainingArgs != null && remainingArgs.length >= 1) {
            projectPath = remainingArgs[0];
        }
        if ((className = cmd.getOptionValue("class")) == null) {
            System.err.println("Option 'class' is mandatory");
            return;
        }
        if (cmd.hasOption("nb")) {
            numberOfMutants = Integer.parseInt(cmd.getOptionValue("nb"));
        }
        Generate.publish(projectPath, className, null, numberOfMutants);
    }

    public static void publish(String projectPath, String className, String testClassName, int numberOfMutants) throws IOException, ClassNotFoundException {
        File test;
        File testDirectory = new File(projectPath + PATH_TEST + File.separator);
        if (!testDirectory.exists()) {
            testDirectory.mkdir();
        }
        Generate.writeTestSuite(projectPath);
        File src = new File(projectPath + PATH_SRC + File.separator + className.replace(".", File.separator) + ".java");
        if (!src.exists()) {
            log.log(Level.SEVERE, "Mutants not generated, Bad class name: " + className);
            return;
        }
        String classShortName = className;
        String pathName = "";
        int index = className.lastIndexOf(".");
        if (index != -1) {
            classShortName = className.substring(index + 1);
            pathName = className.substring(0, index + 1);
        }
        if (testClassName == null) {
            testClassName = pathName + "Test" + classShortName;
        }
        if (!(test = new File(projectPath + PATH_SRC + File.separator + ((String)testClassName).replace(".", File.separator) + ".java")).exists()) {
            log.log(Level.SEVERE, "Mutants not generated, bad name for class of test: " + (String)testClassName);
            return;
        }
        for (int i = 1; i <= numberOfMutants; ++i) {
            Object postFix = Integer.toString(i);
            if (i < 10) {
                postFix = "0" + (String)postFix;
            }
            postFix = "mutant_" + (String)postFix;
            String packaging = "package " + (String)postFix + ";";
            testDirectory = new File(projectPath + PATH_TEST + File.separator + (String)postFix + File.separator);
            if (testDirectory.exists()) continue;
            testDirectory.mkdir();
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(testDirectory.toPath().resolve(src.toPath().getFileName()).toFile()), "UTF-8"));
                BufferedReader reader = new BufferedReader(new FileReader(src));
                writer.write(packaging);
                writer.newLine();
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains("class")) {
                        writer.newLine();
                        writer.write("import caseine.extra.utils.mutations.Mutant;");
                        writer.newLine();
                        writer.newLine();
                        writer.write("@Mutant(testClass = \"" + (String)testClassName + "\", errorMessage = \"@TODO: Define the helper to kill this mutant\")");
                        writer.newLine();
                    }
                    if (!line.contains("package")) {
                        writer.write(line);
                        writer.newLine();
                    }
                    line = reader.readLine();
                }
                reader.close();
                writer.close();
                continue;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private static void writeTestSuite(String projectPath) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("import org.junit.runners.Suite;\n");
        sb.append("import caseine.extra.utils.mutations.FactoryRunnerSuite;\n\n");
        sb.append("import org.junit.runner.RunWith;\n\n");
        sb.append("@RunWith(Suite.class)\n");
        sb.append("@Suite.SuiteClasses({FactoryRunnerSuite.class})\n");
        sb.append("public class MutationTestSuite {\n");
        sb.append("\t//nothing\n");
        sb.append("}");
        Files.write(Paths.get(projectPath + PATH_TEST + File.separator + "MutationTestSuite.java", new String[0]), sb.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    static {
        options.addOption("class", "Class Name", true, "");
        options.addOption("nb", "Number of mutants", true, "");
    }
}

