/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime;

import com.googlecode.aviator.Expression;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Env;
import java.lang.reflect.Constructor;
import java.util.List;

public class LambdaFunctionBootstrap {
    private final String name;
    private final Expression expression;
    private final Constructor<?> constructor;
    private final List<String> arguments;
    private final boolean inheritEnv;

    public String getName() {
        return this.name;
    }

    public LambdaFunctionBootstrap(String name, Expression expression, Constructor<?> constructor, List<String> arguments, boolean inheritEnv) {
        this.name = name;
        this.expression = expression;
        this.constructor = constructor;
        this.arguments = arguments;
        this.inheritEnv = inheritEnv;
    }

    public LambdaFunction newInstance(Env env) {
        try {
            LambdaFunction fn = (LambdaFunction)this.constructor.newInstance(this.arguments, this.expression, env);
            fn.setInheritEnv(this.inheritEnv);
            return fn;
        }
        catch (ExpressionRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ExpressionRuntimeException("Fail to create lambda instance.", t);
        }
    }
}

