/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer.token;

import com.googlecode.aviator.lexer.token.Token;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AbstractToken<T>
implements Token<T>,
Serializable {
    private static final long serialVersionUID = 4498841242745542399L;
    private final int startIndex;
    protected final String lexeme;
    private Map<String, Object> metaMap;

    @Override
    public Map<String, Object> getMetaMap() {
        return this.metaMap;
    }

    public void setMetaMap(Map<String, Object> metaMap) {
        assert (metaMap == null || metaMap instanceof IdentityHashMap);
        this.metaMap = metaMap;
    }

    @Override
    public Token<T> withMeta(String name, Object v) {
        if (this.metaMap == null) {
            this.metaMap = new IdentityHashMap<String, Object>();
        }
        this.metaMap.put(name, v);
        return this;
    }

    @Override
    public <V> V getMeta(String name, V defaultVal) {
        if (this.metaMap == null) {
            return defaultVal;
        }
        Object val = this.metaMap.get(name);
        if (val == null) {
            return defaultVal;
        }
        return (V)val;
    }

    public AbstractToken(int startIndex, String lexeme) {
        this.startIndex = startIndex;
        this.lexeme = lexeme;
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    public String toString() {
        return "[type='" + this.getType().name() + "',lexeme='" + this.getLexeme() + "',index=" + this.startIndex + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lexeme == null ? 0 : this.lexeme.hashCode());
        result = 31 * result + this.startIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractToken other = (AbstractToken)obj;
        if (this.lexeme == null ? other.lexeme != null : !this.lexeme.equals(other.lexeme)) {
            return false;
        }
        return this.startIndex == other.startIndex;
    }
}

