/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum Feature {
    Assignment,
    Return,
    If,
    ForLoop,
    WhileLoop,
    Let(Feature.asSet(Assignment)),
    LexicalScope,
    Lambda,
    Fn(Feature.asSet(Assignment, Lambda)),
    InternalVars,
    Module,
    ExceptionHandle,
    NewInstance,
    StringInterpolation(Feature.asSet(InternalVars));

    private Set<Feature> prequires = Collections.emptySet();

    private Feature() {
    }

    private Feature(Set<Feature> prequires) {
        this.prequires = prequires;
    }

    public static Set<Feature> asSet(Feature ... args) {
        HashSet<Feature> set = new HashSet<Feature>();
        for (Feature f : args) {
            set.addAll(f.prequires);
            set.add(f);
        }
        return set;
    }

    public Set<Feature> getPrequires() {
        return this.prequires;
    }

    public static Set<Feature> getFullFeatures() {
        return Feature.asSet(Feature.values());
    }

    public static Set<Feature> getCompatibleFeatures() {
        return Feature.asSet(Assignment, Lambda, InternalVars);
    }
}

