/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.resource.ContextClassLoaderLocator;
import org.carrot2.util.resource.DirLocator;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ResourceLookup {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLookup.class);
    private final IResourceLocator[] locators;

    public ResourceLookup(Location ... locations) {
        this.locators = new IResourceLocator[locations.length];
        for (int i = 0; i < this.locators.length; ++i) {
            this.locators[i] = locations[i].locator;
        }
    }

    public ResourceLookup(IResourceLocator ... locators) {
        this.locators = Arrays.copyOf(locators, locators.length);
    }

    public ResourceLookup(List<IResourceLocator> locators) {
        this(locators.toArray(new IResourceLocator[locators.size()]));
    }

    public IResource[] getAll(String resource) {
        StringBuilder logEntry = new StringBuilder();
        logEntry.append("getAll(").append("):\n\t").append(resource);
        ArrayList result = Lists.newArrayList();
        for (IResourceLocator locator : this.locators) {
            IResource[] hits = locator.getAll(resource);
            logEntry.append("\n\t- ").append(hits.length + " " + ResourceLookup.pluralize("hit", hits.length) + " from: ").append(locator);
            for (int j = 0; j < hits.length; ++j) {
                logEntry.append("\n\t  - ").append(hits[j]);
                if (result.contains(hits[j])) continue;
                result.add(hits[j]);
            }
        }
        logger.debug(logEntry.toString());
        return result.toArray(new IResource[result.size()]);
    }

    public IResource getFirst(String resource) {
        StringBuilder logEntry = new StringBuilder();
        logEntry.append("getFirst(").append("):\n\t").append(resource);
        IResource result = null;
        for (IResourceLocator locator : this.locators) {
            if (result == null) {
                IResource[] hits = locator.getAll(resource);
                int hitsLength = hits != null ? hits.length : 0;
                logEntry.append("\n\t- ").append(hitsLength + " " + ResourceLookup.pluralize("hit", hitsLength) + " from: ").append(locator);
                if (hits == null || hitsLength <= 0) continue;
                for (int i = 0; i < hitsLength; ++i) {
                    logEntry.append("\n\t\t- ").append(hits[0]);
                }
                result = hits[0];
                continue;
            }
            logEntry.append("\n\t- 0 hits [not scanned] from: ").append(locator);
        }
        logger.debug(logEntry.toString());
        return result;
    }

    public IResourceLocator[] getLocators() {
        return Arrays.copyOf(this.locators, this.locators.length);
    }

    private static String pluralize(String string, int value) {
        if (value == 1) {
            return string;
        }
        return string + "s";
    }

    public int hashCode() {
        return ArrayUtils.hashCode((Object)this.locators);
    }

    public boolean equals(Object target) {
        if (target == this) {
            return true;
        }
        if (target != null && target instanceof ResourceLookup) {
            return ArrayUtils.isEquals((Object)this.locators, (Object)((ResourceLookup)target).locators);
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + Arrays.toString(this.locators) + "]";
    }

    public static enum Location {
        CONTEXT_CLASS_LOADER(new ContextClassLoaderLocator()),
        CURRENT_WORKING_DIRECTORY(new DirLocator(new File(".")));

        public final IResourceLocator locator;

        private Location(IResourceLocator locator) {
            this.locator = locator;
        }
    }
}

