/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import org.apache.http.client.HttpResponseException;
import org.carrot2.core.Document;
import org.carrot2.core.HttpAuthHub;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.SimpleSearchEngine;
import org.carrot2.source.xml.XmlDocumentSourceHelper;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.httpclient.HttpRedirectStrategy;
import org.carrot2.util.httpclient.HttpUtils;
import org.carrot2.util.resource.IResource;

@Bindable
public abstract class RemoteXmlSimpleSearchEngineBase
extends SimpleSearchEngine {
    private final XmlDocumentSourceHelper xmlDocumentSourceHelper = new XmlDocumentSourceHelper();
    @Input
    @Processing
    @Attribute
    @Label(value="HTTP redirect strategy")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    @Internal
    public HttpRedirectStrategy redirectStrategy = HttpRedirectStrategy.NO_REDIRECTS;
    private Templates toCarrot2Xslt;

    public void init(IControllerContext context) {
        super.init(context);
        this.toCarrot2Xslt = this.xmlDocumentSourceHelper.loadXslt(this.getXsltResource());
    }

    public void beforeProcessing() throws ProcessingException {
        super.beforeProcessing();
        if (this.toCarrot2Xslt == null) {
            throw new ProcessingException("XSLT stylesheet must not be null");
        }
    }

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        String serviceURL = this.buildServiceUrl();
        SearchEngineResponse response = new SearchEngineResponse();
        ProcessingResult processingResult = this.loadProcessingResult(serviceURL, this.toCarrot2Xslt, this.getXsltParameters(), response.metadata, this.getUser(), this.getPassword(), this.redirectStrategy);
        List<Document> documents = processingResult.getDocuments();
        if (documents != null) {
            response.results.addAll(documents);
            Map<String, Object> resultAttributes = processingResult.getAttributes();
            response.metadata.put("resultsTotal", resultAttributes.containsKey("results-total") ? resultAttributes.get("results-total") : Long.valueOf(documents.size()));
        } else {
            response.metadata.put("resultsTotal", 0L);
        }
        this.afterFetch(response);
        this.afterFetch(response, processingResult);
        return response;
    }

    protected void afterFetch(SearchEngineResponse response, ProcessingResult processingResult) {
    }

    protected abstract IResource getXsltResource();

    protected Map<String, String> getXsltParameters() {
        return null;
    }

    protected abstract String buildServiceUrl();

    protected String getUser() {
        return HttpAuthHub.getUser();
    }

    protected String getPassword() {
        char[] password = HttpAuthHub.getPassword();
        return password == null ? null : new String(password);
    }

    protected ProcessingResult loadProcessingResult(String url, Templates stylesheet, Map<String, String> xsltParameters, Map<String, Object> metadata, String user, String password, HttpRedirectStrategy redirectStrategy) throws Exception {
        HttpUtils.Response response = HttpUtils.doGET(url, null, null, user, password, this.xmlDocumentSourceHelper.timeout * 1000, redirectStrategy.value());
        InputStream carrot2XmlStream = response.getPayloadAsStream();
        int statusCode = response.status;
        if (statusCode == 200) {
            metadata.put("compression", response.compression);
            return this.xmlDocumentSourceHelper.loadProcessingResult(carrot2XmlStream, stylesheet, xsltParameters);
        }
        throw new HttpResponseException(statusCode, response.statusMessage);
    }
}

