/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.StringUtils;

public enum LanguageCode {
    ARABIC("ar"),
    BULGARIAN("bg"),
    CZECH("cz"),
    CHINESE_SIMPLIFIED("zh_cn"),
    CROATIAN("hr"),
    DANISH("da"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESTONIAN("ee"),
    FINNISH("fi"),
    FRENCH("fr"),
    GERMAN("de"),
    GREEK("gr"),
    HUNGARIAN("hu"),
    HINDI("hi"),
    ITALIAN("it"),
    IRISH("ie"),
    JAPANESE("ja"),
    KOREAN("ko"),
    LATVIAN("lv"),
    LITHUANIAN("lt"),
    MALTESE("mt"),
    NORWEGIAN("no"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SLOVAK("sk"),
    SLOVENE("sl"),
    SPANISH("es"),
    SWEDISH("sv"),
    THAI("th"),
    TURKISH("tr");

    private final String isoCode;
    private final Locale locale;
    private static final Map<String, LanguageCode> isoToLangCode;
    private static final Set<LanguageCode> noSpaceLanguages;

    private LanguageCode(String isoCode) {
        this.isoCode = isoCode;
        this.locale = new Locale(isoCode);
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static LanguageCode forISOCode(String language) {
        language = language.toLowerCase();
        return isoToLangCode.get(language);
    }

    public boolean usesSpaceDelimiters() {
        return !noSpaceLanguages.contains((Object)this);
    }

    public String toString() {
        return StringUtils.identifierToHumanReadable(this.name());
    }

    static {
        isoToLangCode = Maps.newHashMap();
        for (LanguageCode langCode : LanguageCode.values()) {
            isoToLangCode.put(langCode.getIsoCode(), langCode);
        }
        noSpaceLanguages = EnumSet.of(CHINESE_SIMPLIFIED, JAPANESE);
    }
}

