/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.lingo;

import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntHashMap;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.clustering.lingo.ILabelAssigner;
import org.carrot2.clustering.lingo.LingoProcessingContext;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.util.Pair;
import org.carrot2.util.attribute.Bindable;

@Bindable
public class UniqueLabelAssigner
implements ILabelAssigner {
    @Override
    public void assignLabels(LingoProcessingContext context, DoubleMatrix2D stemCos, IntIntHashMap filteredRowToStemIndex, DoubleMatrix2D phraseCos) {
        PreprocessingContext preprocessingContext = context.preprocessingContext;
        int firstPhraseIndex = preprocessingContext.allLabels.firstPhraseIndex;
        int[] labelsFeatureIndex = preprocessingContext.allLabels.featureIndex;
        int[] mostFrequentOriginalWordIndex = preprocessingContext.allStems.mostFrequentOriginalWordIndex;
        int desiredClusterCount = stemCos.columns();
        IntArrayList clusterLabelFeatureIndex = new IntArrayList(desiredClusterCount);
        DoubleArrayList clusterLabelScore = new DoubleArrayList(desiredClusterCount);
        for (int label = 0; label < desiredClusterCount; ++label) {
            double phraseScore;
            Pair<Integer, Integer> stemMax = this.max(stemCos);
            Pair<Integer, Integer> phraseMax = this.max(phraseCos);
            if (stemMax == null && phraseMax == null) break;
            double stemScore = stemMax != null ? stemCos.getQuick(((Integer)stemMax.objectA).intValue(), ((Integer)stemMax.objectB).intValue()) : -1.0;
            double d = phraseScore = phraseMax != null ? phraseCos.getQuick(((Integer)phraseMax.objectA).intValue(), ((Integer)phraseMax.objectB).intValue()) : -1.0;
            if (phraseScore > stemScore) {
                phraseCos.viewRow(((Integer)phraseMax.objectA).intValue()).assign(0.0);
                phraseCos.viewColumn(((Integer)phraseMax.objectB).intValue()).assign(0.0);
                stemCos.viewColumn(((Integer)phraseMax.objectB).intValue()).assign(0.0);
                clusterLabelFeatureIndex.add(labelsFeatureIndex[(Integer)phraseMax.objectA + firstPhraseIndex]);
                clusterLabelScore.add(phraseScore);
                continue;
            }
            stemCos.viewRow(((Integer)stemMax.objectA).intValue()).assign(0.0);
            stemCos.viewColumn(((Integer)stemMax.objectB).intValue()).assign(0.0);
            if (phraseCos != null) {
                phraseCos.viewColumn(((Integer)stemMax.objectB).intValue()).assign(0.0);
            }
            clusterLabelFeatureIndex.add(mostFrequentOriginalWordIndex[filteredRowToStemIndex.get(((Integer)stemMax.objectA).intValue())]);
            clusterLabelScore.add(stemScore);
        }
        context.clusterLabelFeatureIndex = clusterLabelFeatureIndex.toArray();
        context.clusterLabelScore = clusterLabelScore.toArray();
    }

    private Pair<Integer, Integer> max(DoubleMatrix2D matrix) {
        if (matrix == null) {
            return null;
        }
        int row = 0;
        int column = 0;
        double value = 0.0;
        for (int r = 0; r < matrix.rows(); ++r) {
            for (int c = 0; c < matrix.columns(); ++c) {
                double currentValue = matrix.getQuick(r, c);
                if (!(currentValue > value)) continue;
                value = currentValue;
                row = r;
                column = c;
            }
        }
        if (value > 0.0) {
            return new Pair<Integer, Integer>(row, column);
        }
        return null;
    }
}

