/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.carlspring.cloud.storage.s3fs.S3FileStore;
import org.carlspring.cloud.storage.s3fs.S3FileSystemProvider;
import org.carlspring.cloud.storage.s3fs.S3Path;
import org.carlspring.cloud.storage.s3fs.cache.S3FileAttributesCache;
import org.carlspring.cloud.storage.s3fs.util.S3Utils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;

public class S3FileSystem
extends FileSystem
implements Comparable<S3FileSystem> {
    private final S3FileSystemProvider provider;
    private final String key;
    private final S3Client client;
    private final String endpoint;
    private S3FileAttributesCache fileAttributesCache;
    private final Properties properties;

    public S3FileSystem(S3FileSystemProvider provider, String key, S3Client client, String endpoint, Properties properties) {
        this.provider = provider;
        this.key = key;
        this.client = client;
        this.endpoint = endpoint;
        this.properties = properties;
        int cacheTTL = Integer.parseInt(String.valueOf(properties.getOrDefault((Object)"s3fs.cache.attributes.ttl", (Object)60000)));
        int cacheSize = Integer.parseInt(String.valueOf(properties.getOrDefault((Object)"s3fs.cache.attributes.size", (Object)30000)));
        this.fileAttributesCache = new S3FileAttributesCache(cacheTTL, cacheSize);
    }

    public S3FileSystem(S3FileSystemProvider provider, String key, S3Client client, String endpoint) {
        this(provider, key, client, endpoint, new Properties());
    }

    @Override
    public S3FileSystemProvider provider() {
        return this.provider;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void close() throws IOException {
        this.fileAttributesCache.invalidateAll();
        this.provider.close(this);
    }

    @Override
    public boolean isOpen() {
        return this.provider.isOpen(this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FileStore fileStore : this.getFileStores()) {
            builder.add((Object)((S3FileStore)fileStore).getRootDirectory());
        }
        return builder.build();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Bucket bucket : this.client.listBuckets().buckets()) {
            builder.add((Object)new S3FileStore(this, bucket.name()));
        }
        return builder.build();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return ImmutableSet.of((Object)"basic", (Object)"posix");
    }

    @Override
    public S3Path getPath(String first, String ... more) {
        if (more.length == 0) {
            return new S3Path(this, first, new String[0]);
        }
        return new S3Path(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    public S3Client getClient() {
        return this.client;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String[] key2Parts(String keyParts) {
        return S3Utils.key2Parts(keyParts);
    }

    public S3FileAttributesCache getFileAttributesCache() {
        return this.fileAttributesCache;
    }

    protected Properties getProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        return copy;
    }

    public String getRequestHeaderCacheControlProperty() {
        return this.properties.getProperty("s3fs.request.header.cache-control", "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileSystem)) {
            return false;
        }
        S3FileSystem other = (S3FileSystem)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.key == null) {
            return other.key == null;
        }
        return this.key.equals(other.key);
    }

    @Override
    public int compareTo(S3FileSystem o) {
        return this.key.compareTo(o.getKey());
    }
}

