/*
 * Decompiled with CFR 0.152.
 */
package org.carlspring.cloud.storage.s3fs;

import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Date;
import org.carlspring.cloud.storage.s3fs.S3FileStoreAttributeView;
import org.carlspring.cloud.storage.s3fs.S3FileSystem;
import org.carlspring.cloud.storage.s3fs.S3Path;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.Owner;

public class S3FileStore
extends FileStore
implements Comparable<S3FileStore> {
    private final S3FileSystem fileSystem;
    private final String name;

    public S3FileStore(S3FileSystem s3FileSystem, String name) {
        this.fileSystem = s3FileSystem;
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return "S3Bucket";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUsableSpace() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getUnallocatedSpace() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(String attributeViewName) {
        return false;
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        if (type != S3FileStoreAttributeView.class) {
            throw new IllegalArgumentException("FileStoreAttributeView of type '" + type.getName() + "' is not supported.");
        }
        Bucket buck = this.getBucket(this.name);
        if (buck != null) {
            Owner owner = this.getClient().getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(this.name).build()).owner();
            return (V)new S3FileStoreAttributeView(Date.from(buck.creationDate()), buck.name(), owner.id(), owner.displayName());
        }
        throw (NoSuchBucketException)NoSuchBucketException.builder().message("Bucket not found: " + this.name).build();
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.getFileStoreAttributeView(S3FileStoreAttributeView.class).getAttribute(attribute);
    }

    public S3FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Bucket getBucket() {
        return this.getBucket(this.name);
    }

    private Bucket getBucket(String bucketName) {
        for (Bucket buck : this.getClient().listBuckets().buckets()) {
            if (!buck.name().equals(bucketName)) continue;
            return buck;
        }
        return null;
    }

    private boolean hasBucket(String bucketName) {
        boolean bucket = false;
        try {
            this.getClient().headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(bucketName).build());
            bucket = true;
        }
        catch (NoSuchBucketException noSuchBucketException) {
            // empty catch block
        }
        return bucket;
    }

    public S3Path getRootDirectory() {
        return new S3Path(this.fileSystem, "/" + this.name(), new String[0]);
    }

    private S3Client getClient() {
        return this.fileSystem.getClient();
    }

    public Owner getOwner() {
        if (this.hasBucket(this.name)) {
            return this.getClient().getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(this.name).build()).owner();
        }
        return this.getClient().listBuckets((ListBucketsRequest)ListBucketsRequest.builder().build()).owner();
    }

    @Override
    public int compareTo(S3FileStore o) {
        if (this == o) {
            return 0;
        }
        return o.name().compareTo(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fileSystem == null ? 0 : this.fileSystem.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileStore)) {
            return false;
        }
        S3FileStore other = (S3FileStore)obj;
        if (this.fileSystem == null ? other.fileSystem != null : !this.fileSystem.equals(other.fileSystem)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }
}

