/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.jcajce.provider.frodo;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import shaded.javax.crypto.KeyGeneratorSpi;
import shaded.javax.crypto.SecretKey;
import shaded.javax.crypto.spec.SecretKeySpec;
import shaded.javax.security.auth.DestroyFailedException;
import shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import shaded.org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import shaded.org.bouncycastle.jcajce.spec.KEMExtractSpec;
import shaded.org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import shaded.org.bouncycastle.pqc.crypto.frodo.FrodoKEMExtractor;
import shaded.org.bouncycastle.pqc.crypto.frodo.FrodoKEMGenerator;
import shaded.org.bouncycastle.pqc.jcajce.provider.frodo.BCFrodoPrivateKey;
import shaded.org.bouncycastle.pqc.jcajce.provider.frodo.BCFrodoPublicKey;
import shaded.org.bouncycastle.util.Arrays;

public class FrodoKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCFrodoPublicKey bCFrodoPublicKey = (BCFrodoPublicKey)this.genSpec.getPublicKey();
            FrodoKEMGenerator frodoKEMGenerator = new FrodoKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = frodoKEMGenerator.generateEncapsulated(bCFrodoPublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation((SecretKey)new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCFrodoPrivateKey bCFrodoPrivateKey = (BCFrodoPrivateKey)this.extSpec.getPrivateKey();
        FrodoKEMExtractor frodoKEMExtractor = new FrodoKEMExtractor(bCFrodoPrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = frodoKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation((SecretKey)new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

