/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.crypto.saber;

import java.security.SecureRandom;
import shaded.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import shaded.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import shaded.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class SABERKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public SABERKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        SABERPublicKeyParameters sABERPublicKeyParameters = (SABERPublicKeyParameters)asymmetricKeyParameter;
        SABEREngine sABEREngine = sABERPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[sABEREngine.getCipherTextSize()];
        byte[] byArray2 = new byte[sABEREngine.getSessionKeySize()];
        sABEREngine.crypto_kem_enc(byArray, byArray2, sABERPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

