/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.crypto.saber;

import shaded.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import shaded.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import shaded.org.bouncycastle.pqc.crypto.saber.SABERKeyParameters;
import shaded.org.bouncycastle.pqc.crypto.saber.SABERParameters;
import shaded.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;

public class SABERKEMExtractor
implements EncapsulatedSecretExtractor {
    private SABEREngine engine;
    private SABERKeyParameters key;

    public SABERKEMExtractor(SABERKeyParameters sABERKeyParameters) {
        this.key = sABERKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(SABERParameters sABERParameters) {
        this.engine = sABERParameters.getEngine();
    }

    public byte[] extractSecret(byte[] byArray) {
        byte[] byArray2 = new byte[this.engine.getSessionKeySize()];
        this.engine.crypto_kem_dec(byArray2, byArray, ((SABERPrivateKeyParameters)this.key).getPrivateKey());
        return byArray2;
    }

    public int getInputSize() {
        return this.engine.getCipherTextSize();
    }
}

