/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import shaded.org.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import shaded.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import shaded.org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import shaded.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import shaded.org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import shaded.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import shaded.org.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.McElieceCCA2KeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.McElieceKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.qtesla.QTESLAKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.rainbow.RainbowKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.sphincsplus.SPHINCSPlusKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import shaded.org.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Security Provider v1.71";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, "java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "shaded.org.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "ARIA", "Blowfish", "Camellia", "CAST5", "CAST6", "ChaCha", "DES", "DESede", "GOST28147", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC2", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Shacal2", "Skipjack", "SM4", "TEA", "Twofish", "Threefish", "VMPC", "VMPCKSA3", "XTEA", "XSalsa20", "OpenSSLPBKDF", "DSTU7624", "GOST3412_2015", "Zuc"};
    private static final String ASYMMETRIC_PACKAGE = "shaded.org.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE", "EXTERNAL"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC", "LMS", "SPHINCSPlus"};
    private static final String DIGEST_PACKAGE = "shaded.org.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka", "Blake3"};
    private static final String KEYSTORE_PACKAGE = "shaded.org.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "shaded.org.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};

    public BouncyCastleProvider() {
        super(PROVIDER_NAME, 1.71, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_GENERIC);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_MACS);
        this.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_CIPHERS);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_GENERIC);
        this.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
        this.loadAlgorithms(KEYSTORE_PACKAGE, KEYSTORES);
        this.loadAlgorithms(SECURE_RANDOM_PACKAGE, SECURE_RANDOMS);
        this.loadPQCKeys();
        this.put("X509Store.CERTIFICATE/COLLECTION", "shaded.org.bouncycastle.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "shaded.org.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "shaded.org.bouncycastle.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "shaded.org.bouncycastle.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "shaded.org.bouncycastle.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "shaded.org.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "shaded.org.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "shaded.org.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "shaded.org.bouncycastle.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "shaded.org.bouncycastle.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "shaded.org.bouncycastle.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "shaded.org.bouncycastle.jce.provider.X509CertPairParser");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "shaded.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "shaded.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "shaded.org.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            this.put("CertPathValidator.RFC3281", "shaded.org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3281", "shaded.org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put("CertPathValidator.RFC3280", "shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put("CertPathBuilder.RFC3280", "shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put("CertPathValidator.PKIX", "shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put("CertPathBuilder.PKIX", "shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put("CertPathValidator.RFC3281", "shaded.org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3281", "shaded.org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put("CertPathValidator.RFC3280", "shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3280", "shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put("CertPathValidator.PKIX", "shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put("CertPathBuilder.PKIX", "shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put("CertStore.Collection", "shaded.org.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "shaded.org.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "shaded.org.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, string + stringArray[i] + "$Mappings");
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + stringArray[i] + "$Mappings : " + exception);
            }
        }
    }

    private void loadPQCKeys() {
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha_256, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha_512, new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.sphincs256, new Sphincs256KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.newHope, new NHKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss, new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmss, new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmssmt, new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.mcEliece, new McElieceKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.mcElieceCca2, new McElieceCCA2KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.rainbow, new RainbowKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.qTESLA_p_I, new QTESLAKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.qTESLA_p_III, new QTESLAKeyFactorySpi());
        this.addKeyInfoConverter(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, new LMSKeyFactorySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    @Override
    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey(string + "." + string2) || this.containsKey("Alg.Alias." + string + "." + string2);
    }

    @Override
    public void addAlgorithm(String string, String string2) {
        if (this.containsKey(string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put(string, string2);
    }

    @Override
    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
        this.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    @Override
    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    @Override
    public void addAttributes(String string, Map<String, String> map) {
        for (String string2 : map.keySet()) {
            String string3 = string + " " + string2;
            if (this.containsKey(string3)) {
                throw new IllegalStateException("duplicate provider attribute key (" + string3 + ") found");
            }
            this.put(string3, map.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }
}

