/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jce;

import java.io.IOException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import shaded.javax.crypto.Mac;
import shaded.javax.crypto.SecretKey;
import shaded.javax.crypto.SecretKeyFactory;
import shaded.javax.crypto.spec.PBEKeySpec;
import shaded.javax.crypto.spec.PBEParameterSpec;
import shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Primitive;
import shaded.org.bouncycastle.asn1.DERNull;
import shaded.org.bouncycastle.asn1.DEROctetString;
import shaded.org.bouncycastle.asn1.pkcs.ContentInfo;
import shaded.org.bouncycastle.asn1.pkcs.MacData;
import shaded.org.bouncycastle.asn1.pkcs.Pfx;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.asn1.x509.DigestInfo;

public class PKCS12Util {
    public static byte[] convertToDefiniteLength(byte[] byArray) throws IOException {
        Pfx pfx = Pfx.getInstance(byArray);
        return pfx.getEncoded("DER");
    }

    public static byte[] convertToDefiniteLength(byte[] byArray, char[] cArray, String string) throws IOException {
        Pfx pfx = Pfx.getInstance(byArray);
        ContentInfo contentInfo = pfx.getAuthSafe();
        ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(contentInfo.getContent());
        ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(aSN1OctetString.getOctets());
        byte[] byArray2 = aSN1Primitive.getEncoded("DER");
        contentInfo = new ContentInfo(contentInfo.getContentType(), new DEROctetString(byArray2));
        MacData macData = pfx.getMacData();
        try {
            int n = macData.getIterationCount().intValue();
            byte[] byArray3 = ASN1OctetString.getInstance(contentInfo.getContent()).getOctets();
            byte[] byArray4 = PKCS12Util.calculatePbeMac(macData.getMac().getAlgorithmId().getAlgorithm(), macData.getSalt(), n, cArray, byArray3, string);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(macData.getMac().getAlgorithmId().getAlgorithm(), DERNull.INSTANCE);
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray4);
            macData = new MacData(digestInfo, macData.getSalt(), n);
        }
        catch (Exception exception) {
            throw new IOException("error constructing MAC: " + exception.toString());
        }
        pfx = new Pfx(contentInfo, macData);
        return pfx.getEncoded("DER");
    }

    private static byte[] calculatePbeMac(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n, char[] cArray, byte[] byArray2, String string) throws Exception {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance((String)aSN1ObjectIdentifier.getId(), (String)string);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n);
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKey secretKey = secretKeyFactory.generateSecret((KeySpec)pBEKeySpec);
        Mac mac = Mac.getInstance((String)aSN1ObjectIdentifier.getId(), (String)string);
        mac.init((Key)secretKey, (AlgorithmParameterSpec)pBEParameterSpec);
        mac.update(byArray2);
        return mac.doFinal();
    }
}

