/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jcajce.provider.symmetric;

import shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import shaded.org.bouncycastle.crypto.engines.Salsa20Engine;
import shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import shaded.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import shaded.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Salsa20 {
    private Salsa20() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Salsa20 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Salsa20Engine(), 8);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Salsa20", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Salsa20.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.SALSA20", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.SALSA20", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.SALSA20", PREFIX + "$AlgParams");
        }
    }
}

