/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jcajce.provider.asymmetric.elgamal;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import shaded.javax.crypto.spec.DHParameterSpec;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shaded.org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import shaded.org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import shaded.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import shaded.org.bouncycastle.crypto.params.ElGamalParameters;
import shaded.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import shaded.org.bouncycastle.jcajce.provider.asymmetric.elgamal.BCElGamalPrivateKey;
import shaded.org.bouncycastle.jcajce.provider.asymmetric.elgamal.BCElGamalPublicKey;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.jce.spec.ElGamalParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    ElGamalKeyGenerationParameters param;
    ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ElGamal");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
        }
        if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
            ElGamalParameterSpec elGamalParameterSpec = (ElGamalParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(elGamalParameterSpec.getP(), elGamalParameterSpec.getG()));
        } else {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL()));
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        Object object;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair;
        if (!this.initialised) {
            asymmetricCipherKeyPair = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
            if (asymmetricCipherKeyPair != null) {
                this.param = new ElGamalKeyGenerationParameters(this.random, new ElGamalParameters(asymmetricCipherKeyPair.getP(), asymmetricCipherKeyPair.getG(), asymmetricCipherKeyPair.getL()));
            } else {
                object = new ElGamalParametersGenerator();
                ((ElGamalParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, ((ElGamalParametersGenerator)object).generateParameters());
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        asymmetricCipherKeyPair = this.engine.generateKeyPair();
        object = (ElGamalPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair((PublicKey)((Object)new BCElGamalPublicKey((ElGamalPublicKeyParameters)object)), (PrivateKey)((Object)new BCElGamalPrivateKey(elGamalPrivateKeyParameters)));
    }
}

