/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jcajce.provider.asymmetric.dh;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import shaded.javax.crypto.spec.DHParameterSpec;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shaded.org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import shaded.org.bouncycastle.crypto.generators.DHParametersGenerator;
import shaded.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import shaded.org.bouncycastle.crypto.params.DHParameters;
import shaded.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import shaded.org.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import shaded.org.bouncycastle.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import shaded.org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import shaded.org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.util.Integers;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DHKeyGenerationParameters param;
    DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
        this.initialised = false;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        try {
            this.param = this.convertParams(secureRandom, dHParameterSpec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    private DHKeyGenerationParameters convertParams(SecureRandom secureRandom, DHParameterSpec dHParameterSpec) {
        if (dHParameterSpec instanceof DHDomainParameterSpec) {
            return new DHKeyGenerationParameters(secureRandom, ((DHDomainParameterSpec)dHParameterSpec).getDomainParameters());
        }
        return new DHKeyGenerationParameters(secureRandom, new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateKeyPair() {
        Object object;
        DHPublicKeyParameters dHPublicKeyParameters;
        Object object2;
        if (!this.initialised) {
            object2 = Integers.valueOf(this.strength);
            if (params.containsKey(object2)) {
                this.param = (DHKeyGenerationParameters)params.get(object2);
            } else {
                dHPublicKeyParameters = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
                if (dHPublicKeyParameters != null) {
                    this.param = this.convertParams(this.random, (DHParameterSpec)dHPublicKeyParameters);
                } else {
                    object = lock;
                    synchronized (object) {
                        if (params.containsKey(object2)) {
                            this.param = (DHKeyGenerationParameters)params.get(object2);
                        } else {
                            DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
                            dHParametersGenerator.init(this.strength, PrimeCertaintyCalculator.getDefaultCertainty(this.strength), this.random);
                            this.param = new DHKeyGenerationParameters(this.random, dHParametersGenerator.generateParameters());
                            params.put(object2, this.param);
                        }
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object2 = this.engine.generateKeyPair();
        dHPublicKeyParameters = (DHPublicKeyParameters)((AsymmetricCipherKeyPair)object2).getPublic();
        object = (DHPrivateKeyParameters)((AsymmetricCipherKeyPair)object2).getPrivate();
        return new KeyPair((PublicKey)((Object)new BCDHPublicKey(dHPublicKeyParameters)), (PrivateKey)((Object)new BCDHPrivateKey((DHPrivateKeyParameters)object)));
    }
}

