/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import shaded.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import shaded.org.bouncycastle.crypto.params.DHParameters;
import shaded.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

