/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.asn1.ocsp;

import shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.org.bouncycastle.asn1.ASN1Integer;
import shaded.org.bouncycastle.asn1.ASN1Object;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Primitive;
import shaded.org.bouncycastle.asn1.ASN1Sequence;
import shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import shaded.org.bouncycastle.asn1.DERSequence;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CertID
extends ASN1Object {
    AlgorithmIdentifier hashAlgorithm;
    ASN1OctetString issuerNameHash;
    ASN1OctetString issuerKeyHash;
    ASN1Integer serialNumber;

    public CertID(AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1Integer aSN1Integer) {
        this.hashAlgorithm = algorithmIdentifier;
        this.issuerNameHash = aSN1OctetString;
        this.issuerKeyHash = aSN1OctetString2;
        this.serialNumber = aSN1Integer;
    }

    private CertID(ASN1Sequence aSN1Sequence) {
        this.hashAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.issuerNameHash = (ASN1OctetString)aSN1Sequence.getObjectAt(1);
        this.issuerKeyHash = (ASN1OctetString)aSN1Sequence.getObjectAt(2);
        this.serialNumber = (ASN1Integer)aSN1Sequence.getObjectAt(3);
    }

    public static CertID getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CertID.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static CertID getInstance(Object object) {
        if (object instanceof CertID) {
            return (CertID)object;
        }
        if (object != null) {
            return new CertID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public ASN1OctetString getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public ASN1OctetString getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(this.hashAlgorithm);
        aSN1EncodableVector.add(this.issuerNameHash);
        aSN1EncodableVector.add(this.issuerKeyHash);
        aSN1EncodableVector.add(this.serialNumber);
        return new DERSequence(aSN1EncodableVector);
    }
}

