/*
 * Decompiled with CFR 0.152.
 */
package shaded.net.i2p.crypto.eddsa.math.bigint;

import java.math.BigInteger;
import shaded.net.i2p.crypto.eddsa.math.Field;
import shaded.net.i2p.crypto.eddsa.math.ScalarOps;
import shaded.net.i2p.crypto.eddsa.math.bigint.BigIntegerLittleEndianEncoding;

public class BigIntegerScalarOps
implements ScalarOps {
    private final BigInteger l;
    private final BigIntegerLittleEndianEncoding enc;

    public BigIntegerScalarOps(Field f, BigInteger l) {
        this.l = l;
        this.enc = new BigIntegerLittleEndianEncoding();
        this.enc.setField(f);
    }

    @Override
    public byte[] reduce(byte[] s2) {
        return this.enc.encode(this.enc.toBigInteger(s2).mod(this.l));
    }

    @Override
    public byte[] multiplyAndAdd(byte[] a, byte[] b, byte[] c) {
        return this.enc.encode(this.enc.toBigInteger(a).multiply(this.enc.toBigInteger(b)).add(this.enc.toBigInteger(c)).mod(this.l));
    }
}

