/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.transaction.spec.script;

import java.nio.ByteBuffer;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;
import shaded.com.bloxbean.cardano.client.crypto.Blake2bUtil;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;
import shaded.com.bloxbean.cardano.client.exception.CborSerializationException;
import shaded.com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import shaded.com.bloxbean.cardano.client.util.HexUtil;
import shaded.com.fasterxml.jackson.annotation.JsonIgnore;

public interface Script {
    default public byte[] serialize() throws CborSerializationException {
        byte[] first = this.getScriptTypeBytes();
        byte[] serializedBytes = this.serializeScriptBody();
        byte[] finalBytes = ByteBuffer.allocate(first.length + serializedBytes.length).put(first).put(serializedBytes).array();
        return finalBytes;
    }

    default public byte[] scriptRefBytes() throws CborSerializationException {
        int type = this.getScriptType();
        byte[] serializedBytes = this.serializeScriptBody();
        Array array = new Array();
        array.add(new UnsignedInteger(type));
        array.add(new ByteString(serializedBytes));
        try {
            return CborSerializationUtil.serialize(array);
        }
        catch (CborException e) {
            throw new CborRuntimeException(e);
        }
    }

    @JsonIgnore
    default public byte[] getScriptHash() throws CborSerializationException {
        return Blake2bUtil.blake2bHash224(this.serialize());
    }

    @JsonIgnore
    default public String getPolicyId() throws CborSerializationException {
        return HexUtil.encodeHexString(this.getScriptHash());
    }

    public DataItem serializeAsDataItem() throws CborSerializationException;

    public byte[] serializeScriptBody() throws CborSerializationException;

    @JsonIgnore
    public byte[] getScriptTypeBytes();

    @JsonIgnore
    public int getScriptType();
}

