/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.crypto.bip39;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.bloxbean.cardano.client.crypto.bip39.Sha256Hash;
import shaded.com.google.common.base.Joiner;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Splitter;
import shaded.com.google.common.io.BaseEncoding;
import shaded.org.bouncycastle.crypto.digests.RIPEMD160Digest;

class Utils {
    public static final Joiner SPACE_JOINER = Joiner.on(" ");
    public static final Splitter WHITESPACE_SPLITTER = Splitter.on(Pattern.compile("\\s+"));
    public static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();
    public static final int MAX_INITIAL_ARRAY_LENGTH = 20;
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static volatile Date mockTime;
    private static final TimeZone UTC;
    private static final int[] bitMask;
    private static Runtime runtime;
    private static OS os;

    Utils() {
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        Preconditions.checkArgument(b.signum() >= 0, "b must be positive or zero");
        Preconditions.checkArgument(numBytes > 0, "numBytes must be positive");
        byte[] src = b.toByteArray();
        byte[] dest = new byte[numBytes];
        boolean isFirstByteOnlyForSign = src[0] == 0;
        int length = isFirstByteOnlyForSign ? src.length - 1 : src.length;
        Preconditions.checkArgument(length <= numBytes, "The given number does not fit in " + numBytes);
        int srcPos = isFirstByteOnlyForSign ? 1 : 0;
        int destPos = numBytes - length;
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static void uint16ToByteArrayLE(int val, byte[] out, int offset) {
        out[offset] = (byte)(0xFF & val);
        out[offset + 1] = (byte)(0xFF & val >> 8);
    }

    public static void uint32ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
    }

    public static void uint32ToByteArrayBE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val >> 24);
        out[offset + 1] = (byte)(0xFFL & val >> 16);
        out[offset + 2] = (byte)(0xFFL & val >> 8);
        out[offset + 3] = (byte)(0xFFL & val);
    }

    public static void int64ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
        out[offset + 4] = (byte)(0xFFL & val >> 32);
        out[offset + 5] = (byte)(0xFFL & val >> 40);
        out[offset + 6] = (byte)(0xFFL & val >> 48);
        out[offset + 7] = (byte)(0xFFL & val >> 56);
    }

    public static void uint16ToByteStreamLE(int val, OutputStream stream) throws IOException {
        stream.write(0xFF & val);
        stream.write(0xFF & val >> 8);
    }

    public static void uint16ToByteStreamBE(int val, OutputStream stream) throws IOException {
        stream.write(0xFF & val >> 8);
        stream.write(0xFF & val);
    }

    public static void uint32ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
    }

    public static void uint32ToByteStreamBE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val >> 24));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val));
    }

    public static void int64ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
        stream.write((int)(0xFFL & val >> 32));
        stream.write((int)(0xFFL & val >> 40));
        stream.write((int)(0xFFL & val >> 48));
        stream.write((int)(0xFFL & val >> 56));
    }

    public static void uint64ToByteStreamLE(BigInteger val, OutputStream stream) throws IOException {
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            throw new RuntimeException("Input too large to encode into a uint64");
        }
        bytes = Utils.reverseBytes(bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            for (int i = 0; i < 8 - bytes.length; ++i) {
                stream.write(0);
            }
        }
    }

    public static int readUint16(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static long readUint32(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24;
    }

    public static long readInt64(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
    }

    public static long readUint32BE(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static int readUint16BE(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static int readUint16FromStream(InputStream is) {
        try {
            return is.read() & 0xFF | (is.read() & 0xFF) << 8;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static long readUint32FromStream(InputStream is) {
        try {
            return (long)is.read() & 0xFFL | ((long)is.read() & 0xFFL) << 8 | ((long)is.read() & 0xFFL) << 16 | ((long)is.read() & 0xFFL) << 24;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[bytes.length - 1 - i];
        }
        return buf;
    }

    public static byte[] sha256hash160(byte[] input) {
        byte[] sha256 = Sha256Hash.hash(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }

    public static BigInteger decodeMPI(byte[] mpi, boolean hasLength) {
        boolean isNegative;
        byte[] buf;
        if (hasLength) {
            int length = (int)Utils.readUint32BE(mpi, 0);
            buf = new byte[length];
            System.arraycopy(mpi, 4, buf, 0, length);
        } else {
            buf = mpi;
        }
        if (buf.length == 0) {
            return BigInteger.ZERO;
        }
        boolean bl = isNegative = (buf[0] & 0x80) == 128;
        if (isNegative) {
            buf[0] = (byte)(buf[0] & 0x7F);
        }
        BigInteger result = new BigInteger(buf);
        return isNegative ? result.negate() : result;
    }

    public static byte[] encodeMPI(BigInteger value, boolean includeLength) {
        byte[] result;
        boolean isNegative;
        if (value.equals(BigInteger.ZERO)) {
            if (!includeLength) {
                return new byte[0];
            }
            return new byte[]{0, 0, 0, 0};
        }
        boolean bl = isNegative = value.signum() < 0;
        if (isNegative) {
            value = value.negate();
        }
        byte[] array = value.toByteArray();
        int length = array.length;
        if ((array[0] & 0x80) == 128) {
            ++length;
        }
        if (includeLength) {
            byte[] result2 = new byte[length + 4];
            System.arraycopy(array, 0, result2, length - array.length + 3, array.length);
            Utils.uint32ToByteArrayBE(length, result2, 0);
            if (isNegative) {
                result2[4] = (byte)(result2[4] | 0x80);
            }
            return result2;
        }
        if (length != array.length) {
            result = new byte[length];
            System.arraycopy(array, 0, result, 1, array.length);
        } else {
            result = array;
        }
        if (isNegative) {
            result[0] = (byte)(result[0] | 0x80);
        }
        return result;
    }

    public static BigInteger decodeCompactBits(long compact) {
        int size = (int)(compact >> 24) & 0xFF;
        byte[] bytes = new byte[4 + size];
        bytes[3] = (byte)size;
        if (size >= 1) {
            bytes[4] = (byte)(compact >> 16 & 0xFFL);
        }
        if (size >= 2) {
            bytes[5] = (byte)(compact >> 8 & 0xFFL);
        }
        if (size >= 3) {
            bytes[6] = (byte)(compact & 0xFFL);
        }
        return Utils.decodeMPI(bytes, true);
    }

    public static long encodeCompactBits(BigInteger value) {
        int size = value.toByteArray().length;
        long result = size <= 3 ? value.longValue() << 8 * (3 - size) : value.shiftRight(8 * (size - 3)).longValue();
        if ((result & 0x800000L) != 0L) {
            result >>= 8;
            ++size;
        }
        result |= (long)(size << 24);
        return result |= value.signum() == -1 ? 0x800000L : 0L;
    }

    public static Date rollMockClock(int seconds) {
        return Utils.rollMockClockMillis(seconds * 1000);
    }

    public static Date rollMockClockMillis(long millis) {
        if (mockTime == null) {
            throw new IllegalStateException("You need to use setMockClock() first.");
        }
        mockTime = new Date(mockTime.getTime() + millis);
        return mockTime;
    }

    public static void setMockClock() {
        mockTime = new Date();
    }

    public static void setMockClock(long mockClockSeconds) {
        mockTime = new Date(mockClockSeconds * 1000L);
    }

    public static void resetMocking() {
        mockTime = null;
    }

    public static Date now() {
        return mockTime != null ? mockTime : new Date();
    }

    public static long currentTimeMillis() {
        return mockTime != null ? mockTime.getTime() : System.currentTimeMillis();
    }

    public static long currentTimeSeconds() {
        return Utils.currentTimeMillis() / 1000L;
    }

    public static String dateTimeFormat(Date dateTime) {
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        iso8601.setTimeZone(UTC);
        return iso8601.format(dateTime);
    }

    public static String dateTimeFormat(long dateTime) {
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        iso8601.setTimeZone(UTC);
        return iso8601.format(dateTime);
    }

    public static boolean checkBitLE(byte[] data, int index) {
        return (data[index >>> 3] & bitMask[7 & index]) != 0;
    }

    public static void setBitLE(byte[] data, int index) {
        int n = index >>> 3;
        data[n] = (byte)(data[n] | bitMask[7 & index]);
    }

    public static boolean isAndroidRuntime() {
        return runtime == Runtime.ANDROID;
    }

    public static boolean isOpenJDKRuntime() {
        return runtime == Runtime.OPENJDK;
    }

    public static boolean isOracleJavaRuntime() {
        return runtime == Runtime.ORACLE_JAVA;
    }

    public static boolean isLinux() {
        return os == OS.LINUX;
    }

    public static boolean isWindows() {
        return os == OS.WINDOWS;
    }

    public static boolean isMac() {
        return os == OS.MAC_OS;
    }

    public static String toString(List<byte[]> stack) {
        ArrayList<CallSite> parts = new ArrayList<CallSite>(stack.size());
        for (byte[] push : stack) {
            parts.add((CallSite)((Object)("[" + HEX.encode(push) + "]")));
        }
        return SPACE_JOINER.join(parts);
    }

    static {
        UTC = TimeZone.getTimeZone("UTC");
        bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        runtime = null;
        os = null;
        String runtimeProp = System.getProperty("java.runtime.name", "").toLowerCase(Locale.US);
        if (runtimeProp.equals("")) {
            runtime = null;
        } else if (runtimeProp.contains("android")) {
            runtime = Runtime.ANDROID;
        } else if (runtimeProp.contains("openjdk")) {
            runtime = Runtime.OPENJDK;
        } else if (runtimeProp.contains("java(tm) se")) {
            runtime = Runtime.ORACLE_JAVA;
        } else {
            log.info("Unknown java.runtime.name '{}'", (Object)runtimeProp);
        }
        String osProp = System.getProperty("os.name", "").toLowerCase(Locale.US);
        if (osProp.equals("")) {
            os = null;
        } else if (osProp.contains("linux")) {
            os = OS.LINUX;
        } else if (osProp.contains("win")) {
            os = OS.WINDOWS;
        } else if (osProp.contains("mac")) {
            os = OS.MAC_OS;
        } else {
            log.info("Unknown os.name '{}'", (Object)runtimeProp);
        }
    }

    private static enum OS {
        LINUX,
        WINDOWS,
        MAC_OS;

    }

    private static enum Runtime {
        ANDROID,
        OPENJDK,
        ORACLE_JAVA;

    }
}

