/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.crypto.bip39;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import shaded.com.bloxbean.cardano.client.crypto.bip39.Utils;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.io.ByteStreams;
import shaded.com.google.common.primitives.Ints;

public class Sha256Hash
implements Serializable,
Comparable<Sha256Hash> {
    public static final int LENGTH = 32;
    public static final Sha256Hash ZERO_HASH = Sha256Hash.wrap(new byte[32]);
    private final byte[] bytes;

    private Sha256Hash(byte[] rawHashBytes) {
        Preconditions.checkArgument(rawHashBytes.length == 32);
        this.bytes = rawHashBytes;
    }

    public static Sha256Hash wrap(byte[] rawHashBytes) {
        return new Sha256Hash(rawHashBytes);
    }

    public static Sha256Hash wrap(String hexString) {
        return Sha256Hash.wrap(Utils.HEX.decode(hexString));
    }

    public static Sha256Hash wrapReversed(byte[] rawHashBytes) {
        return Sha256Hash.wrap(Utils.reverseBytes(rawHashBytes));
    }

    public static Sha256Hash of(byte[] contents) {
        return Sha256Hash.wrap(Sha256Hash.hash(contents));
    }

    public static Sha256Hash twiceOf(byte[] contents) {
        return Sha256Hash.wrap(Sha256Hash.hashTwice(contents));
    }

    public static Sha256Hash twiceOf(byte[] content1, byte[] content2) {
        return Sha256Hash.wrap(Sha256Hash.hashTwice(content1, content2));
    }

    public static Sha256Hash of(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            Sha256Hash sha256Hash = Sha256Hash.of(ByteStreams.toByteArray(in));
            return sha256Hash;
        }
    }

    public static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash(byte[] input) {
        return Sha256Hash.hash(input, 0, input.length);
    }

    public static byte[] hash(byte[] input, int offset, int length) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input, offset, length);
        return digest.digest();
    }

    public static byte[] hashTwice(byte[] input) {
        return Sha256Hash.hashTwice(input, 0, input.length);
    }

    public static byte[] hashTwice(byte[] input1, byte[] input2) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input1);
        digest.update(input2);
        return digest.digest(digest.digest());
    }

    public static byte[] hashTwice(byte[] input, int offset, int length) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input, offset, length);
        return digest.digest(digest.digest());
    }

    public static byte[] hashTwice(byte[] input1, int offset1, int length1, byte[] input2, int offset2, int length2) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input1, offset1, length1);
        digest.update(input2, offset2, length2);
        return digest.digest(digest.digest());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Sha256Hash)o).bytes);
    }

    public int hashCode() {
        return Ints.fromBytes(this.bytes[28], this.bytes[29], this.bytes[30], this.bytes[31]);
    }

    public String toString() {
        return Utils.HEX.encode(this.bytes);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getReversedBytes() {
        return Utils.reverseBytes(this.bytes);
    }

    @Override
    public int compareTo(Sha256Hash other) {
        for (int i = 31; i >= 0; --i) {
            int thisByte = this.bytes[i] & 0xFF;
            int otherByte = other.bytes[i] & 0xFF;
            if (thisByte > otherByte) {
                return 1;
            }
            if (thisByte >= otherByte) continue;
            return -1;
        }
        return 0;
    }
}

