/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.crypto.bip32.util;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import shaded.com.bloxbean.cardano.client.crypto.CryptoException;
import shaded.javax.crypto.Mac;
import shaded.javax.crypto.spec.SecretKeySpec;

public class Hmac {
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String HMAC_SHA512 = "HmacSHA512";

    public static byte[] hmac256(byte[] message, byte[] secret) {
        try {
            Mac mac = Mac.getInstance((String)HMAC_SHA256);
            SecretKeySpec keySpec = new SecretKeySpec(secret, HMAC_SHA256);
            mac.init((Key)keySpec);
            return mac.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new CryptoException("Unable to perform HmacSHA256.", e);
        }
    }

    public static byte[] hmac512(byte[] message, byte[] secret) {
        try {
            Mac mac = Mac.getInstance((String)HMAC_SHA512);
            SecretKeySpec keySpec = new SecretKeySpec(secret, HMAC_SHA512);
            mac.init((Key)keySpec);
            return mac.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new CryptoException("Unable to perform HmacSHA512.", e);
        }
    }
}

