/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.crypto;

import java.util.List;
import shaded.co.nstant.in.cbor.CborBuilder;
import shaded.co.nstant.in.cbor.CborDecoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import shaded.com.bloxbean.cardano.client.exception.CborDeserializationException;
import shaded.com.bloxbean.cardano.client.exception.CborSerializationException;
import shaded.com.bloxbean.cardano.client.util.HexUtil;
import shaded.org.bouncycastle.util.encoders.Hex;

public class KeyGenCborUtil {
    public static String bytesToCbor(byte[] bytes) throws CborSerializationException {
        CborBuilder cborBuilder = new CborBuilder();
        try {
            List<DataItem> dataItems = cborBuilder.add(bytes).build();
            byte[] encodedBytes = CborSerializationUtil.serialize(dataItems.toArray(new DataItem[0]));
            return Hex.toHexString(encodedBytes);
        }
        catch (CborException e) {
            throw new CborSerializationException("Cbor serialization error", e);
        }
    }

    public static byte[] cborToBytes(String cbor) throws CborDeserializationException {
        List<DataItem> dataItemList = null;
        try {
            dataItemList = CborDecoder.decode(HexUtil.decodeHexString(cbor));
        }
        catch (CborException e) {
            throw new CborDeserializationException("Cbor deserialization error", e);
        }
        byte[] bytes = ((ByteString)dataItemList.get(0)).getBytes();
        return bytes;
    }
}

