/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.common.cbor;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import lombok.NonNull;
import shaded.co.nstant.in.cbor.CborBuilder;
import shaded.co.nstant.in.cbor.CborDecoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.NegativeInteger;
import shaded.co.nstant.in.cbor.model.Number;
import shaded.co.nstant.in.cbor.model.UnicodeString;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;
import shaded.com.bloxbean.cardano.client.common.cbor.custom.CustomCborEncoder;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;
import shaded.com.bloxbean.cardano.client.util.HexUtil;

public class CborSerializationUtil {
    public static BigInteger getBigInteger(DataItem valueItem) {
        BigInteger value = null;
        if (MajorType.UNSIGNED_INTEGER.equals((Object)valueItem.getMajorType()) || MajorType.NEGATIVE_INTEGER.equals((Object)valueItem.getMajorType())) {
            value = ((Number)valueItem).getValue();
        } else if (MajorType.BYTE_STRING.equals((Object)valueItem.getMajorType())) {
            if (valueItem.getTag().getValue() == 2L) {
                value = new BigInteger(((ByteString)valueItem).getBytes());
            } else if (valueItem.getTag().getValue() == 3L) {
                value = new BigInteger(((ByteString)valueItem).getBytes()).multiply(BigInteger.valueOf(-1L));
            }
        }
        return value;
    }

    public static Number bigIntegerToDataItem(BigInteger bi) {
        if (bi.compareTo(BigInteger.ZERO) == -1) {
            return new NegativeInteger(bi);
        }
        return new UnsignedInteger(bi);
    }

    public static long toLong(DataItem valueItem) {
        return CborSerializationUtil.getBigInteger(valueItem).longValue();
    }

    public static int toInt(DataItem valueItem) {
        return CborSerializationUtil.getBigInteger(valueItem).intValue();
    }

    public static String toHex(DataItem di) {
        return HexUtil.encodeHexString(((ByteString)di).getBytes());
    }

    public static byte[] toBytes(DataItem di) {
        return ((ByteString)di).getBytes();
    }

    public static String toUnicodeString(DataItem di) {
        return ((UnicodeString)di).getString();
    }

    public static byte[] serialize(DataItem value) throws CborException {
        return CborSerializationUtil.serialize(new DataItem[]{value}, true);
    }

    public static byte[] serialize(DataItem value, boolean canonical) throws CborException {
        return CborSerializationUtil.serialize(new DataItem[]{value}, canonical);
    }

    public static byte[] serialize(DataItem[] values) throws CborException {
        return CborSerializationUtil.serialize(values, true);
    }

    public static byte[] serialize(DataItem[] values, boolean canonical) throws CborException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CborBuilder cborBuilder = new CborBuilder();
        for (DataItem value : values) {
            cborBuilder.add(value);
        }
        if (canonical) {
            new CustomCborEncoder(baos).encode(cborBuilder.build());
        } else {
            new CustomCborEncoder(baos).nonCanonical().encode(cborBuilder.build());
        }
        byte[] encodedBytes = baos.toByteArray();
        return encodedBytes;
    }

    public static DataItem deserialize(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        try {
            return CborDecoder.decode(bytes).get(0);
        }
        catch (CborException e) {
            throw new CborRuntimeException("Cbor de-serialization error", e);
        }
    }
}

