/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.UnicodeString;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEItem;
import shaded.com.bloxbean.cardano.client.cip.cip8.ProtectedHeaderMap;
import shaded.com.bloxbean.cardano.client.cip.cip8.SigContext;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

public class SigStructure
implements COSEItem {
    ProtectedHeaderMap bodyProtected;
    ProtectedHeaderMap signProtected;
    private SigContext sigContext;
    private byte[] externalAad;
    private byte[] payload;

    public static SigStructure deserialize(@NonNull DataItem dataItem) {
        if (dataItem == null) {
            throw new NullPointerException("dataItem is marked non-null but is null");
        }
        if (!MajorType.ARRAY.equals((Object)dataItem.getMajorType())) {
            throw new CborRuntimeException(String.format("Cbor de-serialization error. Expected Array. Found: %s", dataItem.getMajorType().toString()));
        }
        Array sigStructArray = (Array)dataItem;
        List<DataItem> sigStructDIs = sigStructArray.getDataItems();
        if (sigStructDIs.size() != 4 && sigStructDIs.size() != 5) {
            throw new CborRuntimeException(String.format("Cbor de-serialization error. Expected no of item in array: 4 or 5, Found: %d", sigStructDIs.size()));
        }
        int index = 0;
        SigStructure sigStructure = new SigStructure();
        String context = ((UnicodeString)sigStructDIs.get(index++)).getString();
        sigStructure.sigContext(SigContext.valueOf(context));
        ProtectedHeaderMap protectedHeaderMap = ProtectedHeaderMap.deserialize(sigStructDIs.get(index++));
        sigStructure.bodyProtected(protectedHeaderMap);
        if (sigStructDIs.size() == 5) {
            sigStructure.signProtected(ProtectedHeaderMap.deserialize(sigStructDIs.get(index++)));
        }
        sigStructure.externalAad(((ByteString)sigStructDIs.get(index++)).getBytes());
        sigStructure.payload(((ByteString)sigStructDIs.get(index++)).getBytes());
        return sigStructure;
    }

    @Override
    public DataItem serialize() {
        Array sigStructArray = new Array();
        if (this.sigContext == null) {
            throw new CborRuntimeException("Serialization error. sigContext can't be null");
        }
        sigStructArray.add(new UnicodeString(this.sigContext.toString()));
        if (this.bodyProtected != null) {
            sigStructArray.add(this.bodyProtected.serialize());
        } else {
            sigStructArray.add(new ByteString(new byte[0]));
        }
        if (this.signProtected != null) {
            sigStructArray.add(this.signProtected.serialize());
        }
        if (this.externalAad != null) {
            sigStructArray.add(new ByteString(this.externalAad));
        } else {
            sigStructArray.add(new ByteString(new byte[0]));
        }
        if (this.payload != null) {
            sigStructArray.add(new ByteString(this.payload));
        } else {
            sigStructArray.add(new ByteString(new byte[0]));
        }
        return sigStructArray;
    }

    public ProtectedHeaderMap bodyProtected() {
        return this.bodyProtected;
    }

    public ProtectedHeaderMap signProtected() {
        return this.signProtected;
    }

    public SigContext sigContext() {
        return this.sigContext;
    }

    public byte[] externalAad() {
        return this.externalAad;
    }

    public byte[] payload() {
        return this.payload;
    }

    public SigStructure bodyProtected(ProtectedHeaderMap bodyProtected) {
        this.bodyProtected = bodyProtected;
        return this;
    }

    public SigStructure signProtected(ProtectedHeaderMap signProtected) {
        this.signProtected = signProtected;
        return this;
    }

    public SigStructure sigContext(SigContext sigContext) {
        this.sigContext = sigContext;
        return this;
    }

    public SigStructure externalAad(byte[] externalAad) {
        this.externalAad = externalAad;
        return this;
    }

    public SigStructure payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigStructure)) {
            return false;
        }
        SigStructure other = (SigStructure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProtectedHeaderMap this$bodyProtected = this.bodyProtected();
        ProtectedHeaderMap other$bodyProtected = other.bodyProtected();
        if (this$bodyProtected == null ? other$bodyProtected != null : !((Object)this$bodyProtected).equals(other$bodyProtected)) {
            return false;
        }
        ProtectedHeaderMap this$signProtected = this.signProtected();
        ProtectedHeaderMap other$signProtected = other.signProtected();
        if (this$signProtected == null ? other$signProtected != null : !((Object)this$signProtected).equals(other$signProtected)) {
            return false;
        }
        SigContext this$sigContext = this.sigContext();
        SigContext other$sigContext = other.sigContext();
        if (this$sigContext == null ? other$sigContext != null : !((Object)((Object)this$sigContext)).equals((Object)other$sigContext)) {
            return false;
        }
        if (!Arrays.equals(this.externalAad(), other.externalAad())) {
            return false;
        }
        return Arrays.equals(this.payload(), other.payload());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SigStructure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtectedHeaderMap $bodyProtected = this.bodyProtected();
        result = result * 59 + ($bodyProtected == null ? 43 : ((Object)$bodyProtected).hashCode());
        ProtectedHeaderMap $signProtected = this.signProtected();
        result = result * 59 + ($signProtected == null ? 43 : ((Object)$signProtected).hashCode());
        SigContext $sigContext = this.sigContext();
        result = result * 59 + ($sigContext == null ? 43 : ((Object)((Object)$sigContext)).hashCode());
        result = result * 59 + Arrays.hashCode(this.externalAad());
        result = result * 59 + Arrays.hashCode(this.payload());
        return result;
    }

    public String toString() {
        return "SigStructure(bodyProtected=" + this.bodyProtected() + ", signProtected=" + this.signProtected() + ", sigContext=" + this.sigContext() + ", externalAad=" + Arrays.toString(this.externalAad()) + ", payload=" + Arrays.toString(this.payload()) + ")";
    }
}

