/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.util.Arrays;
import shaded.co.nstant.in.cbor.CborDecoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEItem;
import shaded.com.bloxbean.cardano.client.cip.cip8.HeaderMap;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

public class ProtectedHeaderMap
implements COSEItem {
    private final byte[] bytes;

    public ProtectedHeaderMap() {
        this.bytes = new byte[0];
    }

    public ProtectedHeaderMap(byte[] bytes) {
        this.bytes = bytes;
    }

    public ProtectedHeaderMap(HeaderMap headerMap) {
        this.bytes = headerMap.serializeAsBytes();
    }

    public static ProtectedHeaderMap deserialize(DataItem dataItem) {
        if (MajorType.BYTE_STRING.equals((Object)dataItem.getMajorType())) {
            byte[] bytes = ((ByteString)dataItem).getBytes();
            return new ProtectedHeaderMap(bytes);
        }
        throw new CborRuntimeException(String.format("Deserialization error: Invalid type for ProtectedHeaderMap, type: %s, expected type: ByteString" + dataItem.getMajorType(), new Object[0]));
    }

    @Override
    public DataItem serialize() {
        if (this.bytes != null) {
            return new ByteString(this.bytes);
        }
        return new ByteString(new byte[0]);
    }

    public HeaderMap getAsHeaderMap() {
        if (this.bytes == null) {
            return null;
        }
        try {
            DataItem dataItem = CborDecoder.decode(this.bytes).get(0);
            return HeaderMap.deserialize(dataItem);
        }
        catch (CborException e) {
            throw new CborRuntimeException("De-serialization error", e);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtectedHeaderMap)) {
            return false;
        }
        ProtectedHeaderMap other = (ProtectedHeaderMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtectedHeaderMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }
}

