/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.Map;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEItem;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSESignature;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEUtil;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

public class HeaderMap
implements COSEItem {
    private Object algorithmId;
    private List<Object> criticality = new ArrayList<Object>();
    private Object contentType;
    private byte[] keyId;
    private byte[] initVector;
    private byte[] partialInitVector;
    private List<COSESignature> counterSignature = new ArrayList<COSESignature>();
    private LinkedHashMap<Object, DataItem> otherHeaders = new LinkedHashMap();

    public static HeaderMap deserialize(@NonNull DataItem dataItem) {
        if (dataItem == null) {
            throw new NullPointerException("dataItem is marked non-null but is null");
        }
        if (!MajorType.MAP.equals((Object)dataItem.getMajorType())) {
            throw new CborRuntimeException("De-serialization error. Expected type: Map, Found : %s" + dataItem.getMajorType());
        }
        Map map = (Map)dataItem;
        HeaderMap headerMap = new HeaderMap();
        Collection<DataItem> keyDIs = map.getKeys();
        for (DataItem keyDI : keyDIs) {
            DataItem valueDI = map.get(keyDI);
            if (keyDI.equals(new UnsignedInteger(1L))) {
                headerMap.algorithmId = COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(valueDI);
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(2L))) {
                if (valueDI == null || !valueDI.getMajorType().equals((Object)MajorType.ARRAY)) continue;
                Array criticalityArray = (Array)valueDI;
                headerMap.criticality = criticalityArray.getDataItems().stream().map(di -> COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(di)).collect(Collectors.toList());
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(3L))) {
                if (valueDI == null) continue;
                headerMap.contentType = COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(valueDI);
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(4L))) {
                if (valueDI == null) continue;
                headerMap.keyId = ((ByteString)valueDI).getBytes();
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(5L))) {
                if (valueDI == null) continue;
                headerMap.initVector = ((ByteString)valueDI).getBytes();
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(6L))) {
                if (valueDI == null) continue;
                headerMap.partialInitVector = ((ByteString)valueDI).getBytes();
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(7L))) {
                if (valueDI == null || !valueDI.getMajorType().equals((Object)MajorType.ARRAY)) continue;
                Array counterSigArray = (Array)valueDI;
                List<DataItem> counterSigDIs = counterSigArray.getDataItems();
                if (counterSigDIs.size() > 0 && MajorType.ARRAY.equals((Object)counterSigDIs.get(0).getMajorType())) {
                    headerMap.counterSignature = counterSigDIs.stream().map(di -> COSESignature.deserialize(di)).collect(Collectors.toList());
                    continue;
                }
                headerMap.addSignature(COSESignature.deserialize(counterSigArray));
                continue;
            }
            headerMap.otherHeaders.put(COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(keyDI), valueDI);
        }
        return headerMap;
    }

    public HeaderMap algorithmId(long algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    public HeaderMap algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    public HeaderMap addCriticality(long crit) {
        this.criticality.add(crit);
        return this;
    }

    public HeaderMap addCriticality(String crit) {
        this.criticality.add(crit);
        return this;
    }

    public HeaderMap contentType(long contentType) {
        this.contentType = contentType;
        return this;
    }

    public HeaderMap contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public HeaderMap addOtherHeader(BigInteger key, DataItem value) {
        this.otherHeaders.put(key, value);
        return this;
    }

    public HeaderMap addOtherHeader(long key, DataItem value) {
        this.otherHeaders.put(key, value);
        return this;
    }

    public HeaderMap addOtherHeader(String key, DataItem value) {
        this.otherHeaders.put(key, value);
        return this;
    }

    public HeaderMap addSignature(COSESignature signature) {
        this.counterSignature.add(signature);
        return this;
    }

    public HeaderMap addOtherHeader(long key, BigInteger value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(String key, BigInteger value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(long key, long value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(String key, long value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(long key, byte[] value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(String key, byte[] value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(long key, String value) {
        return this._addOtherHeader(key, value);
    }

    public HeaderMap addOtherHeader(String key, String value) {
        return this._addOtherHeader(key, value);
    }

    public String otherHeaderAsString(String key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return String.valueOf(COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem));
    }

    public String otherHeaderAsString(long key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return String.valueOf(COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem));
    }

    public byte[] otherHeaderAsBytes(String key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (byte[])COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    public byte[] otherHeaderAsBytes(long key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (byte[])COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    public long otherHeaderAsLong(String key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (Long)COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    public long otherHeaderAsLong(long key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (Long)COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    private HeaderMap _addOtherHeader(Object key, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.otherHeaders.put(key, COSEUtil.getDataItemFromObject(value));
        return this;
    }

    @Override
    public Map serialize() {
        Map map = new Map();
        if (this.algorithmId != null) {
            map.put(new UnsignedInteger(1L), COSEUtil.getDataItemFromObject(this.algorithmId));
        }
        if (this.criticality != null && this.criticality.size() > 0) {
            Array valueArray = new Array();
            this.criticality.stream().forEach(crit -> valueArray.add(COSEUtil.getDataItemFromObject(crit)));
            map.put(new UnsignedInteger(2L), valueArray);
        }
        if (this.contentType != null) {
            map.put(new UnsignedInteger(3L), COSEUtil.getDataItemFromObject(this.contentType));
        }
        if (this.keyId != null) {
            map.put(new UnsignedInteger(4L), new ByteString(this.keyId));
        }
        if (this.initVector != null) {
            map.put(new UnsignedInteger(5L), new ByteString(this.initVector));
        }
        if (this.partialInitVector != null) {
            map.put(new UnsignedInteger(6L), new ByteString(this.partialInitVector));
        }
        if (this.counterSignature != null && this.counterSignature.size() > 0) {
            List<DataItem> values = this.counterSignature.stream().map(coseSignature -> coseSignature.serialize()).collect(Collectors.toList());
            if (values.size() == 1) {
                map.put(new UnsignedInteger(7L), (DataItem)values.get(0));
            } else {
                Array valueArray = new Array();
                values.forEach(dataItem -> valueArray.add((DataItem)dataItem));
                map.put(new UnsignedInteger(7L), valueArray);
            }
        }
        this.otherHeaders.forEach((key, value) -> map.put(COSEUtil.getDataItemFromObject(key), (DataItem)value));
        return map;
    }

    public Object algorithmId() {
        return this.algorithmId;
    }

    public List<Object> criticality() {
        return this.criticality;
    }

    public Object contentType() {
        return this.contentType;
    }

    public byte[] keyId() {
        return this.keyId;
    }

    public byte[] initVector() {
        return this.initVector;
    }

    public byte[] partialInitVector() {
        return this.partialInitVector;
    }

    public List<COSESignature> counterSignature() {
        return this.counterSignature;
    }

    public LinkedHashMap<Object, DataItem> otherHeaders() {
        return this.otherHeaders;
    }

    public HeaderMap criticality(List<Object> criticality) {
        this.criticality = criticality;
        return this;
    }

    public HeaderMap keyId(byte[] keyId) {
        this.keyId = keyId;
        return this;
    }

    public HeaderMap initVector(byte[] initVector) {
        this.initVector = initVector;
        return this;
    }

    public HeaderMap partialInitVector(byte[] partialInitVector) {
        this.partialInitVector = partialInitVector;
        return this;
    }

    public HeaderMap counterSignature(List<COSESignature> counterSignature) {
        this.counterSignature = counterSignature;
        return this;
    }

    public HeaderMap otherHeaders(LinkedHashMap<Object, DataItem> otherHeaders) {
        this.otherHeaders = otherHeaders;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderMap)) {
            return false;
        }
        HeaderMap other = (HeaderMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$algorithmId = this.algorithmId();
        Object other$algorithmId = other.algorithmId();
        if (this$algorithmId == null ? other$algorithmId != null : !this$algorithmId.equals(other$algorithmId)) {
            return false;
        }
        List<Object> this$criticality = this.criticality();
        List<Object> other$criticality = other.criticality();
        if (this$criticality == null ? other$criticality != null : !((Object)this$criticality).equals(other$criticality)) {
            return false;
        }
        Object this$contentType = this.contentType();
        Object other$contentType = other.contentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        if (!Arrays.equals(this.keyId(), other.keyId())) {
            return false;
        }
        if (!Arrays.equals(this.initVector(), other.initVector())) {
            return false;
        }
        if (!Arrays.equals(this.partialInitVector(), other.partialInitVector())) {
            return false;
        }
        List<COSESignature> this$counterSignature = this.counterSignature();
        List<COSESignature> other$counterSignature = other.counterSignature();
        if (this$counterSignature == null ? other$counterSignature != null : !((Object)this$counterSignature).equals(other$counterSignature)) {
            return false;
        }
        LinkedHashMap<Object, DataItem> this$otherHeaders = this.otherHeaders();
        LinkedHashMap<Object, DataItem> other$otherHeaders = other.otherHeaders();
        return !(this$otherHeaders == null ? other$otherHeaders != null : !((Object)this$otherHeaders).equals(other$otherHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeaderMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $algorithmId = this.algorithmId();
        result = result * 59 + ($algorithmId == null ? 43 : $algorithmId.hashCode());
        List<Object> $criticality = this.criticality();
        result = result * 59 + ($criticality == null ? 43 : ((Object)$criticality).hashCode());
        Object $contentType = this.contentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        result = result * 59 + Arrays.hashCode(this.keyId());
        result = result * 59 + Arrays.hashCode(this.initVector());
        result = result * 59 + Arrays.hashCode(this.partialInitVector());
        List<COSESignature> $counterSignature = this.counterSignature();
        result = result * 59 + ($counterSignature == null ? 43 : ((Object)$counterSignature).hashCode());
        LinkedHashMap<Object, DataItem> $otherHeaders = this.otherHeaders();
        result = result * 59 + ($otherHeaders == null ? 43 : ((Object)$otherHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "HeaderMap(algorithmId=" + this.algorithmId() + ", criticality=" + this.criticality() + ", contentType=" + this.contentType() + ", keyId=" + Arrays.toString(this.keyId()) + ", initVector=" + Arrays.toString(this.initVector()) + ", partialInitVector=" + Arrays.toString(this.partialInitVector()) + ", counterSignature=" + this.counterSignature() + ", otherHeaders=" + this.otherHeaders() + ")";
    }
}

