/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.math.BigInteger;
import lombok.NonNull;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.NegativeInteger;
import shaded.co.nstant.in.cbor.model.UnicodeString;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

class COSEUtil {
    COSEUtil() {
    }

    public static DataItem getDataItemFromObject(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (value instanceof Long) {
            if ((Long)value >= 0L) {
                return new UnsignedInteger((Long)value);
            }
            return new NegativeInteger((Long)value);
        }
        if (value instanceof Integer) {
            if ((Integer)value >= 0) {
                return new UnsignedInteger(((Integer)value).intValue());
            }
            return new NegativeInteger(((Integer)value).intValue());
        }
        if (value instanceof BigInteger) {
            BigInteger valueBI = (BigInteger)value;
            if (valueBI.compareTo(BigInteger.ZERO) == 0 || valueBI.compareTo(BigInteger.ZERO) == 1) {
                return new UnsignedInteger(valueBI);
            }
            return new NegativeInteger(valueBI);
        }
        if (value instanceof String) {
            return new UnicodeString((String)value);
        }
        if (value instanceof byte[]) {
            return new ByteString((byte[])value);
        }
        throw new CborRuntimeException(String.format("Serialization error. Expected type: long / Integer / BigInteger / String / byte[], found: %s", value.getClass()));
    }

    public static Object decodeNumberOrTextOrBytesTypeFromDataItem(DataItem dataItem) {
        if (dataItem == null) {
            return null;
        }
        if (MajorType.UNSIGNED_INTEGER.equals((Object)dataItem.getMajorType())) {
            return ((UnsignedInteger)dataItem).getValue().longValue();
        }
        if (MajorType.NEGATIVE_INTEGER.equals((Object)dataItem.getMajorType())) {
            return ((NegativeInteger)dataItem).getValue().longValue();
        }
        if (MajorType.UNICODE_STRING.equals((Object)dataItem.getMajorType())) {
            return ((UnicodeString)dataItem).getString();
        }
        if (MajorType.BYTE_STRING.equals((Object)dataItem.getMajorType())) {
            return ((ByteString)dataItem).getBytes();
        }
        throw new CborRuntimeException(String.format("De-serialization error: Unexpected data type: " + dataItem.getMajorType(), new Object[0]));
    }
}

