/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEItem;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSESignature;
import shaded.com.bloxbean.cardano.client.cip.cip8.Headers;
import shaded.com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

public class COSESign
implements COSEItem {
    private Headers headers;
    private byte[] payload;
    private List<COSESignature> signatures = new ArrayList<COSESignature>();

    public static COSESign deserialize(DataItem dataItem) {
        Headers headers;
        if (!MajorType.ARRAY.equals((Object)dataItem.getMajorType())) {
            throw new CborRuntimeException(String.format("De-serialization error. Expected type: Array, Found: %s", new Object[]{dataItem.getMajorType()}));
        }
        Array coseSignArray = (Array)dataItem;
        List<DataItem> coseSignDIs = coseSignArray.getDataItems();
        if (coseSignDIs.size() != 4) {
            throw new CborRuntimeException(String.format("De-serialization error. Invalid array size. Expected size: , Found: %s", coseSignDIs.size()));
        }
        COSESign coseSign = new COSESign();
        coseSign.headers = headers = Headers.deserialize(new DataItem[]{coseSignDIs.get(0), coseSignDIs.get(1)});
        coseSign.payload = (byte[])(coseSignDIs.get(2) == SimpleValue.NULL ? null : ((ByteString)coseSignDIs.get(2)).getBytes());
        Array signatureArray = (Array)coseSignDIs.get(3);
        List<DataItem> signatureDIs = signatureArray.getDataItems();
        coseSign.signatures(signatureDIs.stream().map(signatureDI -> COSESignature.deserialize(signatureDI)).collect(Collectors.toList()));
        return coseSign;
    }

    public COSESign addSignature(COSESignature signature) {
        this.signatures.add(signature);
        return this;
    }

    @Override
    public Array serialize() {
        Array cosignArray = new Array();
        Arrays.stream(this.headers.serialize()).forEach(headerItem -> cosignArray.add((DataItem)headerItem));
        if (this.payload != null && this.payload.length > 0) {
            cosignArray.add(new ByteString(this.payload));
        } else {
            cosignArray.add(SimpleValue.NULL);
        }
        if (this.signatures == null || this.signatures.size() <= 0) {
            throw new CborRuntimeException("Cbor serialization failed. One or more signature required");
        }
        Array signatureArray = new Array();
        this.signatures.forEach(signature -> signatureArray.add(signature.serialize()));
        cosignArray.add(signatureArray);
        return cosignArray;
    }

    @Override
    public byte[] serializeAsBytes() {
        Array di = this.serialize();
        try {
            return CborSerializationUtil.serialize(di, false);
        }
        catch (CborException e) {
            throw new CborRuntimeException("Cbor serializaion error", e);
        }
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] payload() {
        return this.payload;
    }

    public List<COSESignature> signatures() {
        return this.signatures;
    }

    public COSESign headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSESign payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public COSESign signatures(List<COSESignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSESign)) {
            return false;
        }
        COSESign other = (COSESign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.payload(), other.payload())) {
            return false;
        }
        List<COSESignature> this$signatures = this.signatures();
        List<COSESignature> other$signatures = other.signatures();
        return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSESign;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.payload());
        List<COSESignature> $signatures = this.signatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        return result;
    }

    public String toString() {
        return "COSESign(headers=" + this.headers() + ", payload=" + Arrays.toString(this.payload()) + ", signatures=" + this.signatures() + ")";
    }

    public COSESign() {
    }

    public COSESign(Headers headers, byte[] payload, List<COSESignature> signatures) {
        this.headers = headers;
        this.payload = payload;
        this.signatures = signatures;
    }
}

