/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEItem;
import shaded.com.bloxbean.cardano.client.cip.cip8.Headers;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

public class COSERecipient
implements COSEItem {
    private Headers headers;
    private byte[] ciphertext;

    public static COSERecipient deserialize(@NonNull Array coseRecptArray) {
        if (coseRecptArray == null) {
            throw new NullPointerException("coseRecptArray is marked non-null but is null");
        }
        List<DataItem> dataItems = coseRecptArray.getDataItems();
        if (dataItems.size() != 3) {
            throw new CborRuntimeException(String.format("De-serialization error. Expected array size: 3, Found: %s", dataItems.size()));
        }
        Headers headers = Headers.deserialize(new DataItem[]{dataItems.get(0), dataItems.get(1)});
        byte[] ciphertext = ((ByteString)dataItems.get(2)).getBytes();
        return new COSERecipient(headers, ciphertext);
    }

    @Override
    public Array serialize() {
        Array cosRecptArray = new Array();
        Arrays.stream(this.headers.serialize()).forEach(header -> cosRecptArray.add((DataItem)header));
        if (this.ciphertext != null) {
            cosRecptArray.add(new ByteString(this.ciphertext));
        } else {
            cosRecptArray.add(SimpleValue.NULL);
        }
        return cosRecptArray;
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] ciphertext() {
        return this.ciphertext;
    }

    public COSERecipient headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSERecipient ciphertext(byte[] ciphertext) {
        this.ciphertext = ciphertext;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSERecipient)) {
            return false;
        }
        COSERecipient other = (COSERecipient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.ciphertext(), other.ciphertext());
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSERecipient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.ciphertext());
        return result;
    }

    public String toString() {
        return "COSERecipient(headers=" + this.headers() + ", ciphertext=" + Arrays.toString(this.ciphertext()) + ")";
    }

    public COSERecipient(Headers headers, byte[] ciphertext) {
        this.headers = headers;
        this.ciphertext = ciphertext;
    }

    public COSERecipient() {
    }
}

