/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.cip.cip8;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import shaded.co.nstant.in.cbor.CborDecoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.Map;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEItem;
import shaded.com.bloxbean.cardano.client.cip.cip8.COSEUtil;
import shaded.com.bloxbean.cardano.client.exception.CborRuntimeException;

public class COSEKey
implements COSEItem {
    private Object keyType;
    private byte[] keyId;
    private Object algorithmId;
    private List<Object> keyOps = new ArrayList<Object>();
    private byte[] baseInitVector;
    private LinkedHashMap<Object, DataItem> otherHeaders = new LinkedHashMap();

    public static COSEKey deserialize(byte[] bytes) {
        try {
            DataItem dataItem = CborDecoder.decode(bytes).get(0);
            return COSEKey.deserialize(dataItem);
        }
        catch (CborException e) {
            throw new CborRuntimeException("De-serialization error.", e);
        }
    }

    public static COSEKey deserialize(DataItem dataItem) {
        if (!MajorType.MAP.equals((Object)dataItem.getMajorType())) {
            throw new CborRuntimeException("De-serialization error. Expected type: Map, Found : %s" + dataItem.getMajorType());
        }
        Map map = (Map)dataItem;
        COSEKey coseKey = new COSEKey();
        Collection<DataItem> keyDIs = map.getKeys();
        for (DataItem keyDI : keyDIs) {
            DataItem valueDI = map.get(keyDI);
            if (keyDI.equals(new UnsignedInteger(1L))) {
                if (valueDI == null) continue;
                coseKey.keyType = COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(valueDI);
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(2L))) {
                if (valueDI == null) continue;
                coseKey.keyId = ((ByteString)valueDI).getBytes();
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(3L))) {
                if (valueDI == null) continue;
                coseKey.algorithmId = COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(valueDI);
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(4L))) {
                if (valueDI == null || !valueDI.getMajorType().equals((Object)MajorType.ARRAY)) continue;
                Array keyOpsArray = (Array)valueDI;
                coseKey.keyOps = keyOpsArray.getDataItems().stream().map(di -> COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(di)).collect(Collectors.toList());
                continue;
            }
            if (keyDI.equals(new UnsignedInteger(5L))) {
                if (valueDI == null) continue;
                coseKey.baseInitVector = ((ByteString)valueDI).getBytes();
                continue;
            }
            coseKey.otherHeaders.put(COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(keyDI), valueDI);
        }
        return coseKey;
    }

    public COSEKey keyType(long keyType) {
        this.keyType = keyType;
        return this;
    }

    public COSEKey keyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public COSEKey algorithmId(long algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    public COSEKey algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    public COSEKey keyOp(long keyOp) {
        this.keyOps.add(keyOp);
        return this;
    }

    public COSEKey keyOp(String keyOp) {
        this.keyOps.add(keyOp);
        return this;
    }

    public COSEKey addOtherHeader(BigInteger key, DataItem value) {
        this.otherHeaders.put(key, value);
        return this;
    }

    public COSEKey addOtherHeader(long key, DataItem value) {
        this.otherHeaders.put(key, value);
        return this;
    }

    public COSEKey addOtherHeader(String key, DataItem value) {
        this.otherHeaders.put(key, value);
        return this;
    }

    public COSEKey addOtherHeader(long key, BigInteger value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(String key, BigInteger value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(long key, long value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(String key, long value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(long key, byte[] value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(String key, String value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(String key, byte[] value) {
        return this._addOtherHeader(key, value);
    }

    public COSEKey addOtherHeader(long key, String value) {
        return this._addOtherHeader(key, value);
    }

    public String otherHeaderAsString(String key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return String.valueOf(COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem));
    }

    public String otherHeaderAsString(long key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return String.valueOf(COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem));
    }

    public byte[] otherHeaderAsBytes(String key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (byte[])COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    public byte[] otherHeaderAsBytes(long key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (byte[])COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    public long otherHeaderAsLong(String key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (Long)COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    public long otherHeaderAsLong(long key) {
        DataItem dataItem = this.otherHeaders.get(key);
        return (Long)COSEUtil.decodeNumberOrTextOrBytesTypeFromDataItem(dataItem);
    }

    private COSEKey _addOtherHeader(Object key, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.otherHeaders.put(key, COSEUtil.getDataItemFromObject(value));
        return this;
    }

    @Override
    public Map serialize() {
        Map map = new Map();
        if (this.keyType != null) {
            map.put(new UnsignedInteger(1L), COSEUtil.getDataItemFromObject(this.keyType));
        }
        if (this.keyId != null) {
            map.put(new UnsignedInteger(2L), new ByteString(this.keyId));
        }
        if (this.algorithmId != null) {
            map.put(new UnsignedInteger(3L), COSEUtil.getDataItemFromObject(this.algorithmId));
        }
        if (this.keyOps != null && this.keyOps.size() > 0) {
            Array valueArray = new Array();
            this.keyOps.stream().forEach(crit -> valueArray.add(COSEUtil.getDataItemFromObject(crit)));
            map.put(new UnsignedInteger(4L), valueArray);
        }
        if (this.baseInitVector != null) {
            map.put(new UnsignedInteger(5L), new ByteString(this.baseInitVector));
        }
        this.otherHeaders.forEach((key, value) -> map.put(COSEUtil.getDataItemFromObject(key), (DataItem)value));
        return map;
    }

    public Object keyType() {
        return this.keyType;
    }

    public byte[] keyId() {
        return this.keyId;
    }

    public Object algorithmId() {
        return this.algorithmId;
    }

    public List<Object> keyOps() {
        return this.keyOps;
    }

    public byte[] baseInitVector() {
        return this.baseInitVector;
    }

    public LinkedHashMap<Object, DataItem> otherHeaders() {
        return this.otherHeaders;
    }

    public COSEKey keyId(byte[] keyId) {
        this.keyId = keyId;
        return this;
    }

    public COSEKey keyOps(List<Object> keyOps) {
        this.keyOps = keyOps;
        return this;
    }

    public COSEKey baseInitVector(byte[] baseInitVector) {
        this.baseInitVector = baseInitVector;
        return this;
    }

    public COSEKey otherHeaders(LinkedHashMap<Object, DataItem> otherHeaders) {
        this.otherHeaders = otherHeaders;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSEKey)) {
            return false;
        }
        COSEKey other = (COSEKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$keyType = this.keyType();
        Object other$keyType = other.keyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        if (!Arrays.equals(this.keyId(), other.keyId())) {
            return false;
        }
        Object this$algorithmId = this.algorithmId();
        Object other$algorithmId = other.algorithmId();
        if (this$algorithmId == null ? other$algorithmId != null : !this$algorithmId.equals(other$algorithmId)) {
            return false;
        }
        List<Object> this$keyOps = this.keyOps();
        List<Object> other$keyOps = other.keyOps();
        if (this$keyOps == null ? other$keyOps != null : !((Object)this$keyOps).equals(other$keyOps)) {
            return false;
        }
        if (!Arrays.equals(this.baseInitVector(), other.baseInitVector())) {
            return false;
        }
        LinkedHashMap<Object, DataItem> this$otherHeaders = this.otherHeaders();
        LinkedHashMap<Object, DataItem> other$otherHeaders = other.otherHeaders();
        return !(this$otherHeaders == null ? other$otherHeaders != null : !((Object)this$otherHeaders).equals(other$otherHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSEKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $keyType = this.keyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        result = result * 59 + Arrays.hashCode(this.keyId());
        Object $algorithmId = this.algorithmId();
        result = result * 59 + ($algorithmId == null ? 43 : $algorithmId.hashCode());
        List<Object> $keyOps = this.keyOps();
        result = result * 59 + ($keyOps == null ? 43 : ((Object)$keyOps).hashCode());
        result = result * 59 + Arrays.hashCode(this.baseInitVector());
        LinkedHashMap<Object, DataItem> $otherHeaders = this.otherHeaders();
        result = result * 59 + ($otherHeaders == null ? 43 : ((Object)$otherHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "COSEKey(keyType=" + this.keyType() + ", keyId=" + Arrays.toString(this.keyId()) + ", algorithmId=" + this.algorithmId() + ", keyOps=" + this.keyOps() + ", baseInitVector=" + Arrays.toString(this.baseInitVector()) + ", otherHeaders=" + this.otherHeaders() + ")";
    }
}

