/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.address.util;

import shaded.com.bloxbean.cardano.client.address.Address;
import shaded.com.bloxbean.cardano.client.address.AddressType;
import shaded.com.bloxbean.cardano.client.address.ByronAddress;
import shaded.com.bloxbean.cardano.client.address.util.AddressEncoderDecoderUtil;
import shaded.com.bloxbean.cardano.client.exception.AddressExcepion;
import shaded.com.bloxbean.cardano.client.exception.AddressRuntimeException;

public class AddressUtil {
    public static boolean isValidAddress(String addr) {
        try {
            AddressUtil.addressToBytes(addr);
            return true;
        }
        catch (AddressExcepion e) {
            return false;
        }
        catch (AddressRuntimeException e) {
            return false;
        }
    }

    public static byte[] addressToBytes(String address) throws AddressExcepion {
        if (address == null) {
            return null;
        }
        if (address.startsWith("addr") || address.startsWith("stake")) {
            Address addressObj = new Address(address);
            return addressObj.getBytes();
        }
        ByronAddress byronAddress = new ByronAddress(address);
        return byronAddress.getBytes();
    }

    public static String bytesToBase58Address(byte[] bytes) throws AddressExcepion {
        AddressType addressType = AddressEncoderDecoderUtil.readAddressType(bytes);
        if (AddressType.Byron.equals((Object)addressType)) {
            ByronAddress byronAddress = new ByronAddress(bytes);
            return byronAddress.toBase58();
        }
        throw new AddressExcepion("Not a Byron address");
    }

    public static String bytesToAddress(byte[] bytes) throws AddressExcepion {
        AddressType addressType = AddressEncoderDecoderUtil.readAddressType(bytes);
        if (AddressType.Byron.equals((Object)addressType)) {
            ByronAddress byronAddress = new ByronAddress(bytes);
            return byronAddress.toBase58();
        }
        Address address = new Address(bytes);
        return address.toBech32();
    }
}

