/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.address;

import shaded.com.bloxbean.cardano.client.address.AddressType;
import shaded.com.bloxbean.cardano.client.address.util.AddressEncoderDecoderUtil;
import shaded.com.bloxbean.cardano.client.crypto.Base58;
import shaded.com.bloxbean.cardano.client.crypto.exception.AddressFormatException;

public class ByronAddress {
    private byte[] bytes;
    private String address;

    public ByronAddress(String address) {
        this.bytes = Base58.decode(address);
        AddressType addressType = AddressEncoderDecoderUtil.readAddressType(this.bytes);
        if (addressType == null || !AddressType.Byron.equals((Object)addressType)) {
            throw new AddressFormatException("Invalid Byron address");
        }
        this.address = address;
    }

    public ByronAddress(byte[] bytes) {
        this.bytes = bytes;
        this.address = Base58.encode(bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toBase58() {
        return this.address;
    }

    public String getAddress() {
        return this.address;
    }
}

