/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.bloxbean.cardano.client.address;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.bloxbean.cardano.client.address.Address;
import shaded.com.bloxbean.cardano.client.address.AddressType;
import shaded.com.bloxbean.cardano.client.address.Pointer;
import shaded.com.bloxbean.cardano.client.address.util.AddressEncoderDecoderUtil;
import shaded.com.bloxbean.cardano.client.common.model.Network;
import shaded.com.bloxbean.cardano.client.crypto.Blake2bUtil;
import shaded.com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import shaded.com.bloxbean.cardano.client.crypto.bip32.util.BytesUtil;
import shaded.com.bloxbean.cardano.client.exception.AddressRuntimeException;
import shaded.com.bloxbean.cardano.client.exception.CborSerializationException;
import shaded.com.bloxbean.cardano.client.transaction.spec.NetworkId;
import shaded.com.bloxbean.cardano.client.transaction.spec.script.Script;
import shaded.com.google.common.primitives.Bytes;

public class AddressProvider {
    private static final Logger log = LoggerFactory.getLogger(AddressProvider.class);

    public static Address getBaseAddress(HdPublicKey paymentKey, HdPublicKey delegationKey, Network networkInfo) {
        if (paymentKey == null || delegationKey == null) {
            throw new AddressRuntimeException("paymentkey and delegationKey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getKeyHash();
        byte[] delegationKeyHash = delegationKey.getKeyHash();
        byte headerType = 0;
        return AddressProvider.getAddress(paymentKeyHash, delegationKeyHash, headerType, networkInfo, AddressType.Base);
    }

    public static Address getBaseAddress(Script paymentKey, HdPublicKey delegationKey, Network networkInfo) throws CborSerializationException {
        if (paymentKey == null || delegationKey == null) {
            throw new AddressRuntimeException("paymentkey and delegationKey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getScriptHash();
        byte[] delegationKeyHash = delegationKey.getKeyHash();
        byte headerType = 16;
        return AddressProvider.getAddress(paymentKeyHash, delegationKeyHash, headerType, networkInfo, AddressType.Base);
    }

    public static Address getBaseAddress(HdPublicKey paymentKey, Script delegationKey, Network networkInfo) throws CborSerializationException {
        if (paymentKey == null || delegationKey == null) {
            throw new AddressRuntimeException("paymentkey and delegationKey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getKeyHash();
        byte[] delegationKeyHash = delegationKey.getScriptHash();
        byte headerType = 32;
        return AddressProvider.getAddress(paymentKeyHash, delegationKeyHash, headerType, networkInfo, AddressType.Base);
    }

    public static Address getBaseAddress(Script paymentKey, Script delegationKey, Network networkInfo) throws CborSerializationException {
        if (paymentKey == null || delegationKey == null) {
            throw new AddressRuntimeException("paymentkey and delegationKey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getScriptHash();
        byte[] delegationKeyHash = delegationKey.getScriptHash();
        byte headerType = 48;
        return AddressProvider.getAddress(paymentKeyHash, delegationKeyHash, headerType, networkInfo, AddressType.Base);
    }

    public static Address getPointerAddress(HdPublicKey paymentKey, Pointer delegationPointer, Network networkInfo) {
        if (paymentKey == null || delegationPointer == null) {
            throw new AddressRuntimeException("paymentkey and delegationKey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getKeyHash();
        byte[] delegationPointerHash = BytesUtil.merge(AddressProvider.variableNatEncode(delegationPointer.slot), AddressProvider.variableNatEncode(delegationPointer.txIndex), AddressProvider.variableNatEncode(delegationPointer.certIndex));
        byte headerType = 64;
        return AddressProvider.getAddress(paymentKeyHash, delegationPointerHash, headerType, networkInfo, AddressType.Ptr);
    }

    public static Address getPointerAddress(Script paymentKey, Pointer delegationPointer, Network networkInfo) throws CborSerializationException {
        if (paymentKey == null || delegationPointer == null) {
            throw new AddressRuntimeException("paymentkey and delegationKey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getScriptHash();
        byte[] delegationPointerHash = BytesUtil.merge(AddressProvider.variableNatEncode(delegationPointer.slot), AddressProvider.variableNatEncode(delegationPointer.txIndex), AddressProvider.variableNatEncode(delegationPointer.certIndex));
        byte headerType = 80;
        return AddressProvider.getAddress(paymentKeyHash, delegationPointerHash, headerType, networkInfo, AddressType.Ptr);
    }

    public static Address getEntAddress(HdPublicKey paymentKey, Network networkInfo) {
        if (paymentKey == null) {
            throw new AddressRuntimeException("paymentkey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getKeyHash();
        byte headerType = 96;
        return AddressProvider.getAddress(paymentKeyHash, null, headerType, networkInfo, AddressType.Enterprise);
    }

    public static Address getEntAddress(Script paymentKey, Network networkInfo) throws CborSerializationException {
        if (paymentKey == null) {
            throw new AddressRuntimeException("paymentkey cannot be null");
        }
        byte[] paymentKeyHash = paymentKey.getScriptHash();
        byte headerType = 112;
        return AddressProvider.getAddress(paymentKeyHash, null, headerType, networkInfo, AddressType.Enterprise);
    }

    public static Address getRewardAddress(HdPublicKey stakeKey, Network networkInfo) {
        if (stakeKey == null) {
            throw new AddressRuntimeException("stakeKey cannot be null");
        }
        byte[] stakeKeyHash = stakeKey.getKeyHash();
        int headerType = 224;
        return AddressProvider.getAddress(null, stakeKeyHash, (byte)headerType, networkInfo, AddressType.Reward);
    }

    public static Address getRewardAddress(Script stakeKey, Network networkInfo) throws CborSerializationException {
        if (stakeKey == null) {
            throw new AddressRuntimeException("stakeKey cannot be null");
        }
        byte[] stakeKeyHash = stakeKey.getScriptHash();
        int headerType = 240;
        return AddressProvider.getAddress(null, stakeKeyHash, (byte)headerType, networkInfo, AddressType.Reward);
    }

    private static Address getAddress(byte[] paymentKeyHash, byte[] stakeKeyHash, byte headerKind, Network networkInfo, AddressType addressType) {
        NetworkId network = AddressEncoderDecoderUtil.getNetworkId(networkInfo);
        String prefix = AddressEncoderDecoderUtil.getPrefixHeader(addressType) + AddressEncoderDecoderUtil.getPrefixTail(network);
        byte header = AddressEncoderDecoderUtil.getAddressHeader(headerKind, networkInfo, addressType);
        byte[] addressArray = AddressProvider.getAddressBytes(paymentKeyHash, stakeKeyHash, addressType, header);
        return new Address(prefix, addressArray);
    }

    private static byte[] getAddressBytes(byte[] paymentKeyHash, byte[] stakeKeyHash, AddressType addressType, byte header) {
        byte[] addressArray;
        switch (addressType) {
            case Base: {
                addressArray = new byte[1 + paymentKeyHash.length + stakeKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(paymentKeyHash, 0, addressArray, 1, paymentKeyHash.length);
                System.arraycopy(stakeKeyHash, 0, addressArray, paymentKeyHash.length + 1, stakeKeyHash.length);
                break;
            }
            case Enterprise: {
                addressArray = new byte[1 + paymentKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(paymentKeyHash, 0, addressArray, 1, paymentKeyHash.length);
                break;
            }
            case Reward: {
                addressArray = new byte[1 + stakeKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(stakeKeyHash, 0, addressArray, 1, stakeKeyHash.length);
                break;
            }
            case Ptr: {
                addressArray = new byte[1 + paymentKeyHash.length + stakeKeyHash.length];
                addressArray[0] = header;
                System.arraycopy(paymentKeyHash, 0, addressArray, 1, paymentKeyHash.length);
                System.arraycopy(stakeKeyHash, 0, addressArray, paymentKeyHash.length + 1, stakeKeyHash.length);
                break;
            }
            default: {
                throw new AddressRuntimeException("Unknown address type");
            }
        }
        return addressArray;
    }

    public static boolean verifyAddress(@NonNull Address address, byte[] publicKey) {
        byte[] newAddressBytes;
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        String prefix = address.getPrefix();
        AddressType addressType = address.getAddressType();
        byte[] addressBytes = address.getBytes();
        byte header = addressBytes[0];
        if (AddressType.Reward.equals((Object)addressType)) {
            byte[] stakeKeyHash = Blake2bUtil.blake2bHash224(publicKey);
            newAddressBytes = AddressProvider.getAddressBytes(null, stakeKeyHash, addressType, header);
        } else {
            byte[] stakeKeyHash = AddressProvider.getDelegationHash(address).orElse(null);
            byte[] paymentKeyHash = Blake2bUtil.blake2bHash224(publicKey);
            newAddressBytes = AddressProvider.getAddressBytes(paymentKeyHash, stakeKeyHash, addressType, header);
        }
        Address newAddress = new Address(prefix, newAddressBytes);
        if (log.isDebugEnabled()) {
            log.debug("Address to compare : " + address.toBech32());
            log.debug("Address derived from pub key : " + newAddress.toBech32());
        }
        return newAddress.toBech32().equals(address.toBech32());
    }

    public static Address getStakeAddress(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (AddressType.Base != address.getAddressType()) {
            throw new AddressRuntimeException(String.format("Stake address can't be derived. Required address type: Base Address, Found: %s ", new Object[]{address.getAddressType()}));
        }
        byte[] stakeKeyHash = AddressProvider.getDelegationHash(address).orElseThrow(() -> new AddressRuntimeException("StakeKeyHash was not found for the address"));
        AddressType addressType = AddressType.Reward;
        byte[] addressBytes = address.getBytes();
        byte header = addressBytes[0];
        int stakeHeader = (header & 0x20) > 0 ? 240 : 224;
        int network = header & 0xF;
        byte[] rewardAddressBytes = AddressProvider.getAddressBytes(null, stakeKeyHash, addressType, (byte)(stakeHeader |= network));
        return new Address(rewardAddressBytes);
    }

    public static Optional<byte[]> getDelegationHash(Address address) {
        byte[] stakeKeyHash;
        AddressType addressType = address.getAddressType();
        byte[] addressBytes = address.getBytes();
        switch (addressType) {
            case Base: {
                stakeKeyHash = new byte[28];
                System.arraycopy(addressBytes, 29, stakeKeyHash, 0, stakeKeyHash.length);
                break;
            }
            case Enterprise: {
                stakeKeyHash = null;
                break;
            }
            case Reward: {
                stakeKeyHash = new byte[28];
                System.arraycopy(addressBytes, 1, stakeKeyHash, 0, stakeKeyHash.length);
                break;
            }
            case Ptr: {
                stakeKeyHash = new byte[addressBytes.length - 1 - 28];
                System.arraycopy(addressBytes, 29, stakeKeyHash, 0, stakeKeyHash.length);
                break;
            }
            default: {
                throw new AddressRuntimeException("DelegationHash can't be found for address type : " + addressType);
            }
        }
        return Optional.ofNullable(stakeKeyHash);
    }

    public static Optional<byte[]> getPaymentKeyHash(Address address) {
        byte[] paymentKeyHash;
        AddressType addressType = address.getAddressType();
        byte[] addressBytes = address.getBytes();
        switch (addressType) {
            case Base: 
            case Enterprise: 
            case Ptr: {
                paymentKeyHash = new byte[28];
                System.arraycopy(addressBytes, 1, paymentKeyHash, 0, paymentKeyHash.length);
                break;
            }
            case Reward: {
                paymentKeyHash = null;
                break;
            }
            default: {
                throw new AddressRuntimeException("Unable to get payment key hash for address type: " + addressType + ", address=" + address.getAddress());
            }
        }
        return Optional.ofNullable(paymentKeyHash);
    }

    public static boolean isPubKeyHashInPaymentPart(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        AddressType addressType = address.getAddressType();
        if (addressType != AddressType.Base && addressType != AddressType.Enterprise && addressType != AddressType.Ptr) {
            if (log.isDebugEnabled()) {
                log.warn("Method not supported for address type=" + addressType + ", address=" + address.getAddress());
            }
            return false;
        }
        byte[] addressBytes = address.getBytes();
        byte header = addressBytes[0];
        return (header & 0x10) == 0;
    }

    public static boolean isScriptHashInPaymentPart(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        AddressType addressType = address.getAddressType();
        if (addressType != AddressType.Base && addressType != AddressType.Enterprise && addressType != AddressType.Ptr) {
            if (log.isDebugEnabled()) {
                log.warn("Method not supported for address type=" + addressType + ", address=" + address.getAddress());
            }
            return false;
        }
        return !AddressProvider.isPubKeyHashInPaymentPart(address);
    }

    public static boolean isStakeKeyHashInDelegationPart(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        AddressType addressType = address.getAddressType();
        if (addressType != AddressType.Base && addressType != AddressType.Ptr && addressType != AddressType.Reward) {
            if (log.isDebugEnabled()) {
                log.warn("Method not supported for address type=" + addressType + ", address=" + address.getAddress());
            }
            return false;
        }
        byte[] addressBytes = address.getBytes();
        byte header = addressBytes[0];
        if (addressType == AddressType.Reward) {
            return (header & 0x10) == 0;
        }
        return (header & 0x20) == 0;
    }

    public static boolean isScriptHashInDelegationPart(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        AddressType addressType = address.getAddressType();
        if (addressType != AddressType.Base && addressType != AddressType.Ptr && addressType != AddressType.Reward) {
            if (log.isDebugEnabled()) {
                log.warn("Method not supported for address type=" + addressType + ", address=" + address.getAddress());
            }
            return false;
        }
        return !AddressProvider.isStakeKeyHashInDelegationPart(address);
    }

    private static byte[] variableNatEncode(long num) {
        ArrayList<Byte> output = new ArrayList<Byte>();
        output.add((byte)(num & 0x7FL));
        num /= 128L;
        while (num > 0L) {
            output.add((byte)(num & 0x7FL | 0x80L));
            num /= 128L;
        }
        Collections.reverse(output);
        return Bytes.toArray(output);
    }
}

