/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.encoder;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import shaded.co.nstant.in.cbor.CborEncoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.encoder.AbstractEncoder;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.co.nstant.in.cbor.model.UnicodeString;

public class UnicodeStringEncoder
extends AbstractEncoder<UnicodeString> {
    public UnicodeStringEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
    }

    @Override
    public void encode(UnicodeString dataItem) throws CborException {
        String string = dataItem.getString();
        if (dataItem.isChunked()) {
            this.encodeTypeChunked(MajorType.UNICODE_STRING);
            if (string != null) {
                this.encode(new UnicodeString(string));
            }
        } else if (string == null) {
            this.encoder.encode(SimpleValue.NULL);
        } else {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            this.encodeTypeAndLength(MajorType.UNICODE_STRING, bytes.length);
            this.write(bytes);
        }
    }
}

