/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.encoder;

import java.io.OutputStream;
import shaded.co.nstant.in.cbor.CborEncoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.encoder.AbstractEncoder;
import shaded.co.nstant.in.cbor.encoder.DoublePrecisionFloatEncoder;
import shaded.co.nstant.in.cbor.encoder.HalfPrecisionFloatEncoder;
import shaded.co.nstant.in.cbor.encoder.SinglePrecisionFloatEncoder;
import shaded.co.nstant.in.cbor.model.DoublePrecisionFloat;
import shaded.co.nstant.in.cbor.model.HalfPrecisionFloat;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.co.nstant.in.cbor.model.SimpleValueType;
import shaded.co.nstant.in.cbor.model.SinglePrecisionFloat;
import shaded.co.nstant.in.cbor.model.Special;

public class SpecialEncoder
extends AbstractEncoder<Special> {
    private final HalfPrecisionFloatEncoder halfPrecisionFloatEncoder;
    private final SinglePrecisionFloatEncoder singlePrecisionFloatEncoder;
    private final DoublePrecisionFloatEncoder doublePrecisionFloatEncoder;

    public SpecialEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
        this.halfPrecisionFloatEncoder = new HalfPrecisionFloatEncoder(encoder, outputStream);
        this.singlePrecisionFloatEncoder = new SinglePrecisionFloatEncoder(encoder, outputStream);
        this.doublePrecisionFloatEncoder = new DoublePrecisionFloatEncoder(encoder, outputStream);
    }

    @Override
    public void encode(Special dataItem) throws CborException {
        block0 : switch (dataItem.getSpecialType()) {
            case BREAK: {
                this.write(255);
                break;
            }
            case SIMPLE_VALUE: {
                SimpleValue simpleValue = (SimpleValue)dataItem;
                switch (simpleValue.getSimpleValueType()) {
                    case FALSE: 
                    case NULL: 
                    case TRUE: 
                    case UNDEFINED: {
                        SimpleValueType type = simpleValue.getSimpleValueType();
                        this.write(0xE0 | type.getValue());
                        break block0;
                    }
                    case UNALLOCATED: {
                        this.write(0xE0 | simpleValue.getValue());
                        break block0;
                    }
                }
                break;
            }
            case UNALLOCATED: {
                throw new CborException("Unallocated special type");
            }
            case IEEE_754_HALF_PRECISION_FLOAT: {
                if (!(dataItem instanceof HalfPrecisionFloat)) {
                    throw new CborException("Wrong data item type");
                }
                this.halfPrecisionFloatEncoder.encode((HalfPrecisionFloat)dataItem);
                break;
            }
            case IEEE_754_SINGLE_PRECISION_FLOAT: {
                if (!(dataItem instanceof SinglePrecisionFloat)) {
                    throw new CborException("Wrong data item type");
                }
                this.singlePrecisionFloatEncoder.encode((SinglePrecisionFloat)dataItem);
                break;
            }
            case IEEE_754_DOUBLE_PRECISION_FLOAT: {
                if (!(dataItem instanceof DoublePrecisionFloat)) {
                    throw new CborException("Wrong data item type");
                }
                this.doublePrecisionFloatEncoder.encode((DoublePrecisionFloat)dataItem);
                break;
            }
            case SIMPLE_VALUE_NEXT_BYTE: {
                if (!(dataItem instanceof SimpleValue)) {
                    throw new CborException("Wrong data item type");
                }
                SimpleValue simpleValueNextByte = (SimpleValue)dataItem;
                this.write(-8, (byte)simpleValueNextByte.getValue());
            }
        }
    }
}

