/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.encoder;

import java.io.OutputStream;
import java.math.BigInteger;
import shaded.co.nstant.in.cbor.CborEncoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.encoder.AbstractEncoder;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.NegativeInteger;

public class NegativeIntegerEncoder
extends AbstractEncoder<NegativeInteger> {
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);

    public NegativeIntegerEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
    }

    @Override
    public void encode(NegativeInteger dataItem) throws CborException {
        this.encodeTypeAndLength(MajorType.NEGATIVE_INTEGER, MINUS_ONE.subtract(dataItem.getValue()).abs());
    }
}

