/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.encoder;

import java.io.OutputStream;
import shaded.co.nstant.in.cbor.CborEncoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.encoder.AbstractEncoder;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.SimpleValue;

public class ByteStringEncoder
extends AbstractEncoder<ByteString> {
    public ByteStringEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
    }

    @Override
    public void encode(ByteString byteString) throws CborException {
        byte[] bytes = byteString.getBytes();
        if (byteString.isChunked()) {
            this.encodeTypeChunked(MajorType.BYTE_STRING);
            if (bytes != null) {
                this.encode(new ByteString(bytes));
            }
        } else if (bytes == null) {
            this.encoder.encode(SimpleValue.NULL);
        } else {
            this.encodeTypeAndLength(MajorType.BYTE_STRING, bytes.length);
            this.write(bytes);
        }
    }
}

