/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.decoder;

import java.io.InputStream;
import shaded.co.nstant.in.cbor.CborDecoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.decoder.AbstractDecoder;
import shaded.co.nstant.in.cbor.decoder.DoublePrecisionFloatDecoder;
import shaded.co.nstant.in.cbor.decoder.HalfPrecisionFloatDecoder;
import shaded.co.nstant.in.cbor.decoder.SinglePrecisionFloatDecoder;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.co.nstant.in.cbor.model.SimpleValueType;
import shaded.co.nstant.in.cbor.model.Special;
import shaded.co.nstant.in.cbor.model.SpecialType;

public class SpecialDecoder
extends AbstractDecoder<Special> {
    private final HalfPrecisionFloatDecoder halfPrecisionFloatDecoder;
    private final SinglePrecisionFloatDecoder singlePrecisionFloatDecoder;
    private final DoublePrecisionFloatDecoder doublePrecisionFloatDecoder;

    public SpecialDecoder(CborDecoder decoder, InputStream inputStream) {
        super(decoder, inputStream);
        this.halfPrecisionFloatDecoder = new HalfPrecisionFloatDecoder(decoder, inputStream);
        this.singlePrecisionFloatDecoder = new SinglePrecisionFloatDecoder(decoder, inputStream);
        this.doublePrecisionFloatDecoder = new DoublePrecisionFloatDecoder(decoder, inputStream);
    }

    @Override
    public Special decode(int initialByte) throws CborException {
        switch (SpecialType.ofByte(initialByte)) {
            case BREAK: {
                return Special.BREAK;
            }
            case SIMPLE_VALUE: {
                switch (SimpleValueType.ofByte(initialByte)) {
                    case FALSE: {
                        return SimpleValue.FALSE;
                    }
                    case TRUE: {
                        return SimpleValue.TRUE;
                    }
                    case NULL: {
                        return SimpleValue.NULL;
                    }
                    case UNDEFINED: {
                        return SimpleValue.UNDEFINED;
                    }
                    case UNALLOCATED: {
                        return new SimpleValue(initialByte & 0x1F);
                    }
                }
                throw new CborException("Not implemented");
            }
            case IEEE_754_HALF_PRECISION_FLOAT: {
                return this.halfPrecisionFloatDecoder.decode(initialByte);
            }
            case IEEE_754_SINGLE_PRECISION_FLOAT: {
                return this.singlePrecisionFloatDecoder.decode(initialByte);
            }
            case IEEE_754_DOUBLE_PRECISION_FLOAT: {
                return this.doublePrecisionFloatDecoder.decode(initialByte);
            }
            case SIMPLE_VALUE_NEXT_BYTE: {
                return new SimpleValue(this.nextSymbol());
            }
        }
        throw new CborException("Not implemented");
    }
}

