/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.decoder;

import java.io.InputStream;
import shaded.co.nstant.in.cbor.CborDecoder;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.decoder.AbstractDecoder;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.Special;

public class ArrayDecoder
extends AbstractDecoder<Array> {
    public ArrayDecoder(CborDecoder decoder, InputStream inputStream) {
        super(decoder, inputStream);
    }

    @Override
    public Array decode(int initialByte) throws CborException {
        long length = this.getLength(initialByte);
        if (length == -1L) {
            return this.decodeInfinitiveLength();
        }
        return this.decodeFixedLength(length);
    }

    private Array decodeInfinitiveLength() throws CborException {
        Array array = new Array();
        array.setChunked(true);
        if (this.decoder.isAutoDecodeInfinitiveArrays()) {
            while (true) {
                DataItem dataItem;
                if ((dataItem = this.decoder.decodeNext()) == null) {
                    throw new CborException("Unexpected end of stream");
                }
                if (Special.BREAK.equals(dataItem)) {
                    array.add(Special.BREAK);
                    break;
                }
                array.add(dataItem);
            }
        }
        return array;
    }

    private Array decodeFixedLength(long length) throws CborException {
        Array array = new Array(this.getPreallocationSize(length));
        for (long i = 0L; i < length; ++i) {
            DataItem dataItem = this.decoder.decodeNext();
            if (dataItem == null) {
                throw new CborException("Unexpected end of stream");
            }
            array.add(dataItem);
        }
        return array;
    }
}

