/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.builder;

import shaded.co.nstant.in.cbor.builder.AbstractBuilder;
import shaded.co.nstant.in.cbor.builder.ArrayBuilder;
import shaded.co.nstant.in.cbor.builder.MapEntryBuilder;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.Map;

public class MapBuilder<T extends AbstractBuilder<?>>
extends AbstractBuilder<T> {
    private final Map map;
    private DataItem lastItem = null;

    public MapBuilder(T parent, Map map) {
        super(parent);
        this.map = map;
    }

    public MapBuilder<T> put(DataItem key, DataItem value) {
        this.map.put(key, value);
        this.lastItem = value;
        return this;
    }

    public MapBuilder<T> put(long key, long value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, boolean value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, float value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, double value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, byte[] value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(long key, String value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, long value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, boolean value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, float value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, double value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, byte[] value) {
        this.map.put(this.convert(key), this.convert(value));
        return this;
    }

    public MapBuilder<T> put(String key, String value) {
        this.put(this.convert(key), this.convert(value));
        return this;
    }

    public ArrayBuilder<MapBuilder<T>> putArray(DataItem key) {
        Array array = new Array();
        this.put(key, array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public ArrayBuilder<MapBuilder<T>> putArray(long key) {
        Array array = new Array();
        this.put(this.convert(key), array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public ArrayBuilder<MapBuilder<T>> putArray(String key) {
        Array array = new Array();
        this.put(this.convert(key), array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public ArrayBuilder<MapBuilder<T>> startArray(DataItem key) {
        Array array = new Array();
        array.setChunked(true);
        this.put(key, array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public ArrayBuilder<MapBuilder<T>> startArray(long key) {
        return this.startArray(this.convert(key));
    }

    public ArrayBuilder<MapBuilder<T>> startArray(String key) {
        Array array = new Array();
        array.setChunked(true);
        this.put(this.convert(key), array);
        return new ArrayBuilder<MapBuilder<T>>(this, array);
    }

    public MapBuilder<MapBuilder<T>> putMap(DataItem key) {
        Map nestedMap = new Map();
        this.put(key, nestedMap);
        return new MapBuilder<MapBuilder<T>>(this, nestedMap);
    }

    public MapBuilder<MapBuilder<T>> putMap(long key) {
        Map nestedMap = new Map();
        this.put(this.convert(key), nestedMap);
        return new MapBuilder<MapBuilder<T>>(this, nestedMap);
    }

    public MapBuilder<MapBuilder<T>> putMap(String key) {
        Map nestedMap = new Map();
        this.put(this.convert(key), nestedMap);
        return new MapBuilder<MapBuilder<T>>(this, nestedMap);
    }

    public MapBuilder<MapBuilder<T>> startMap(DataItem key) {
        Map nestedMap = new Map();
        nestedMap.setChunked(true);
        this.put(key, nestedMap);
        return new MapBuilder<MapBuilder<T>>(this, nestedMap);
    }

    public MapBuilder<T> tagged(long tag) {
        if (this.lastItem == null) {
            throw new IllegalStateException("Can't add a tag before adding an item");
        }
        this.lastItem.getOuterTaggable().setTag(tag);
        return this;
    }

    public MapBuilder<MapBuilder<T>> startMap(long key) {
        return this.startMap(this.convert(key));
    }

    public MapBuilder<MapBuilder<T>> startMap(String key) {
        return this.startMap(this.convert(key));
    }

    public T end() {
        return (T)((AbstractBuilder)this.getParent());
    }

    public MapEntryBuilder<MapBuilder<T>> addKey(long key) {
        return new MapEntryBuilder<MapBuilder<T>>(this, this.convert(key));
    }

    public MapEntryBuilder<MapBuilder<T>> addKey(String key) {
        return new MapEntryBuilder<MapBuilder<T>>(this, this.convert(key));
    }
}

