/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.builder;

import shaded.co.nstant.in.cbor.builder.AbstractBuilder;
import shaded.co.nstant.in.cbor.builder.MapBuilder;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.Map;
import shaded.co.nstant.in.cbor.model.SimpleValue;

public class ArrayBuilder<T extends AbstractBuilder<?>>
extends AbstractBuilder<T> {
    private final Array array;

    public ArrayBuilder(T parent, Array array) {
        super(parent);
        this.array = array;
    }

    public ArrayBuilder<T> add(DataItem dataItem) {
        this.array.add(dataItem);
        return this;
    }

    public ArrayBuilder<T> add(long value) {
        this.add(this.convert(value));
        return this;
    }

    public ArrayBuilder<T> add(boolean value) {
        this.add(this.convert(value));
        return this;
    }

    public ArrayBuilder<T> add(float value) {
        this.add(this.convert(value));
        return this;
    }

    public ArrayBuilder<T> add(double value) {
        this.add(this.convert(value));
        return this;
    }

    public ArrayBuilder<T> add(byte[] bytes) {
        this.add(this.convert(bytes));
        return this;
    }

    public ArrayBuilder<T> add(String string) {
        this.add(this.convert(string));
        return this;
    }

    public ArrayBuilder<T> tagged(long tag) {
        DataItem item = this.array.peekLast();
        if (item == null) {
            throw new IllegalStateException("Can't add a tag before adding an item");
        }
        item.getOuterTaggable().setTag(tag);
        return this;
    }

    public ArrayBuilder<ArrayBuilder<T>> addArray() {
        Array nestedArray = new Array();
        this.add(nestedArray);
        return new ArrayBuilder<ArrayBuilder<T>>(this, nestedArray);
    }

    public ArrayBuilder<ArrayBuilder<T>> startArray() {
        Array nestedArray = new Array();
        nestedArray.setChunked(true);
        this.add(nestedArray);
        return new ArrayBuilder<ArrayBuilder<T>>(this, nestedArray);
    }

    public MapBuilder<ArrayBuilder<T>> addMap() {
        Map nestedMap = new Map();
        this.add(nestedMap);
        return new MapBuilder<ArrayBuilder<T>>(this, nestedMap);
    }

    public MapBuilder<ArrayBuilder<T>> startMap() {
        Map nestedMap = new Map();
        nestedMap.setChunked(true);
        this.add(nestedMap);
        return new MapBuilder<ArrayBuilder<T>>(this, nestedMap);
    }

    public T end() {
        if (this.array.isChunked()) {
            this.add(SimpleValue.BREAK);
        }
        return (T)((AbstractBuilder)this.getParent());
    }
}

