/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.decoder.HalfPrecisionFloatDecoder;
import shaded.co.nstant.in.cbor.encoder.HalfPrecisionFloatEncoder;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.DoublePrecisionFloat;
import shaded.co.nstant.in.cbor.model.HalfPrecisionFloat;
import shaded.co.nstant.in.cbor.model.NegativeInteger;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.co.nstant.in.cbor.model.SinglePrecisionFloat;
import shaded.co.nstant.in.cbor.model.Tag;
import shaded.co.nstant.in.cbor.model.UnicodeString;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;

public abstract class AbstractBuilder<T> {
    private final T parent;

    public AbstractBuilder(T parent) {
        this.parent = parent;
    }

    protected T getParent() {
        return this.parent;
    }

    protected void addChunk(DataItem dataItem) {
        throw new IllegalStateException();
    }

    protected DataItem convert(long value) {
        if (value >= 0L) {
            return new UnsignedInteger(value);
        }
        return new NegativeInteger(value);
    }

    protected DataItem convert(BigInteger value) {
        if (value.signum() == -1) {
            return new NegativeInteger(value);
        }
        return new UnsignedInteger(value);
    }

    protected DataItem convert(boolean value) {
        if (value) {
            return SimpleValue.TRUE;
        }
        return SimpleValue.FALSE;
    }

    protected DataItem convert(byte[] bytes) {
        return new ByteString(bytes);
    }

    protected DataItem convert(String string) {
        return new UnicodeString(string);
    }

    protected DataItem convert(float value) {
        if (this.isHalfPrecisionEnough(value)) {
            return new HalfPrecisionFloat(value);
        }
        return new SinglePrecisionFloat(value);
    }

    protected DataItem convert(double value) {
        return new DoublePrecisionFloat(value);
    }

    protected Tag tag(long value) {
        return new Tag(value);
    }

    private boolean isHalfPrecisionEnough(float value) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            HalfPrecisionFloatEncoder encoder = this.getHalfPrecisionFloatEncoder(outputStream);
            encoder.encode(new HalfPrecisionFloat(value));
            byte[] bytes = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            HalfPrecisionFloatDecoder decoder = this.getHalfPrecisionFloatDecoder(inputStream);
            if (inputStream.read() == -1) {
                throw new CborException("unexpected end of stream");
            }
            HalfPrecisionFloat halfPrecisionFloat = decoder.decode(0);
            return value == halfPrecisionFloat.getValue();
        }
        catch (CborException cborException) {
            return false;
        }
    }

    protected HalfPrecisionFloatEncoder getHalfPrecisionFloatEncoder(OutputStream outputStream) {
        return new HalfPrecisionFloatEncoder(null, outputStream);
    }

    protected HalfPrecisionFloatDecoder getHalfPrecisionFloatDecoder(InputStream inputStream) {
        return new HalfPrecisionFloatDecoder(null, inputStream);
    }
}

