/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor;

import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.encoder.ArrayEncoder;
import shaded.co.nstant.in.cbor.encoder.ByteStringEncoder;
import shaded.co.nstant.in.cbor.encoder.MapEncoder;
import shaded.co.nstant.in.cbor.encoder.NegativeIntegerEncoder;
import shaded.co.nstant.in.cbor.encoder.SpecialEncoder;
import shaded.co.nstant.in.cbor.encoder.TagEncoder;
import shaded.co.nstant.in.cbor.encoder.UnicodeStringEncoder;
import shaded.co.nstant.in.cbor.encoder.UnsignedIntegerEncoder;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.Map;
import shaded.co.nstant.in.cbor.model.NegativeInteger;
import shaded.co.nstant.in.cbor.model.SimpleValue;
import shaded.co.nstant.in.cbor.model.Special;
import shaded.co.nstant.in.cbor.model.Tag;
import shaded.co.nstant.in.cbor.model.UnicodeString;
import shaded.co.nstant.in.cbor.model.UnsignedInteger;

public class CborEncoder {
    private final UnsignedIntegerEncoder unsignedIntegerEncoder;
    private final NegativeIntegerEncoder negativeIntegerEncoder;
    private final ByteStringEncoder byteStringEncoder;
    private final UnicodeStringEncoder unicodeStringEncoder;
    private final ArrayEncoder arrayEncoder;
    private final MapEncoder mapEncoder;
    private final TagEncoder tagEncoder;
    private final SpecialEncoder specialEncoder;
    private boolean canonical = true;

    public CborEncoder(OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        this.unsignedIntegerEncoder = new UnsignedIntegerEncoder(this, outputStream);
        this.negativeIntegerEncoder = new NegativeIntegerEncoder(this, outputStream);
        this.byteStringEncoder = new ByteStringEncoder(this, outputStream);
        this.unicodeStringEncoder = new UnicodeStringEncoder(this, outputStream);
        this.arrayEncoder = new ArrayEncoder(this, outputStream);
        this.mapEncoder = new MapEncoder(this, outputStream);
        this.tagEncoder = new TagEncoder(this, outputStream);
        this.specialEncoder = new SpecialEncoder(this, outputStream);
    }

    public void encode(List<DataItem> dataItems) throws CborException {
        for (DataItem dataItem : dataItems) {
            this.encode(dataItem);
        }
    }

    public void encode(DataItem dataItem) throws CborException {
        if (dataItem == null) {
            dataItem = SimpleValue.NULL;
        }
        if (dataItem.hasTag()) {
            Tag tagDi = dataItem.getTag();
            this.encode(tagDi);
        }
        switch (dataItem.getMajorType()) {
            case UNSIGNED_INTEGER: {
                this.unsignedIntegerEncoder.encode((UnsignedInteger)dataItem);
                break;
            }
            case NEGATIVE_INTEGER: {
                this.negativeIntegerEncoder.encode((NegativeInteger)dataItem);
                break;
            }
            case BYTE_STRING: {
                this.byteStringEncoder.encode((ByteString)dataItem);
                break;
            }
            case UNICODE_STRING: {
                this.unicodeStringEncoder.encode((UnicodeString)dataItem);
                break;
            }
            case ARRAY: {
                this.arrayEncoder.encode((Array)dataItem);
                break;
            }
            case MAP: {
                this.mapEncoder.encode((Map)dataItem);
                break;
            }
            case SPECIAL: {
                this.specialEncoder.encode((Special)dataItem);
                break;
            }
            case TAG: {
                this.tagEncoder.encode((Tag)dataItem);
                break;
            }
            default: {
                throw new CborException("Unknown major type");
            }
        }
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public CborEncoder nonCanonical() {
        this.canonical = false;
        return this;
    }
}

