/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import shaded.co.nstant.in.cbor.CborException;
import shaded.co.nstant.in.cbor.DataItemListener;
import shaded.co.nstant.in.cbor.decoder.ArrayDecoder;
import shaded.co.nstant.in.cbor.decoder.ByteStringDecoder;
import shaded.co.nstant.in.cbor.decoder.MapDecoder;
import shaded.co.nstant.in.cbor.decoder.NegativeIntegerDecoder;
import shaded.co.nstant.in.cbor.decoder.SpecialDecoder;
import shaded.co.nstant.in.cbor.decoder.TagDecoder;
import shaded.co.nstant.in.cbor.decoder.UnicodeStringDecoder;
import shaded.co.nstant.in.cbor.decoder.UnsignedIntegerDecoder;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.LanguageTaggedString;
import shaded.co.nstant.in.cbor.model.MajorType;
import shaded.co.nstant.in.cbor.model.Number;
import shaded.co.nstant.in.cbor.model.RationalNumber;
import shaded.co.nstant.in.cbor.model.Tag;
import shaded.co.nstant.in.cbor.model.UnicodeString;

public class CborDecoder {
    private final InputStream inputStream;
    private final UnsignedIntegerDecoder unsignedIntegerDecoder;
    private final NegativeIntegerDecoder negativeIntegerDecoder;
    private final ByteStringDecoder byteStringDecoder;
    private final UnicodeStringDecoder unicodeStringDecoder;
    private final ArrayDecoder arrayDecoder;
    private final MapDecoder mapDecoder;
    private final TagDecoder tagDecoder;
    private final SpecialDecoder specialDecoder;
    private boolean autoDecodeInfinitiveArrays = true;
    private boolean autoDecodeInfinitiveMaps = true;
    private boolean autoDecodeInfinitiveByteStrings = true;
    private boolean autoDecodeInfinitiveUnicodeStrings = true;
    private boolean autoDecodeRationalNumbers = true;
    private boolean autoDecodeLanguageTaggedStrings = true;
    private boolean rejectDuplicateKeys = false;

    public CborDecoder(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        this.inputStream = inputStream;
        this.unsignedIntegerDecoder = new UnsignedIntegerDecoder(this, inputStream);
        this.negativeIntegerDecoder = new NegativeIntegerDecoder(this, inputStream);
        this.byteStringDecoder = new ByteStringDecoder(this, inputStream);
        this.unicodeStringDecoder = new UnicodeStringDecoder(this, inputStream);
        this.arrayDecoder = new ArrayDecoder(this, inputStream);
        this.mapDecoder = new MapDecoder(this, inputStream);
        this.tagDecoder = new TagDecoder(this, inputStream);
        this.specialDecoder = new SpecialDecoder(this, inputStream);
    }

    public static List<DataItem> decode(byte[] bytes) throws CborException {
        return new CborDecoder(new ByteArrayInputStream(bytes)).decode();
    }

    public List<DataItem> decode() throws CborException {
        DataItem dataItem;
        LinkedList<DataItem> dataItems = new LinkedList<DataItem>();
        while ((dataItem = this.decodeNext()) != null) {
            dataItems.add(dataItem);
        }
        return dataItems;
    }

    public void decode(DataItemListener dataItemListener) throws CborException {
        Objects.requireNonNull(dataItemListener);
        DataItem dataItem = this.decodeNext();
        while (dataItem != null) {
            dataItemListener.onDataItem(dataItem);
            dataItem = this.decodeNext();
        }
    }

    public DataItem decodeNext() throws CborException {
        int symbol;
        try {
            symbol = this.inputStream.read();
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
        if (symbol == -1) {
            return null;
        }
        switch (MajorType.ofByte(symbol)) {
            case ARRAY: {
                return this.arrayDecoder.decode(symbol);
            }
            case BYTE_STRING: {
                return this.byteStringDecoder.decode(symbol);
            }
            case MAP: {
                return this.mapDecoder.decode(symbol);
            }
            case NEGATIVE_INTEGER: {
                return this.negativeIntegerDecoder.decode(symbol);
            }
            case UNICODE_STRING: {
                return this.unicodeStringDecoder.decode(symbol);
            }
            case UNSIGNED_INTEGER: {
                return this.unsignedIntegerDecoder.decode(symbol);
            }
            case SPECIAL: {
                return this.specialDecoder.decode(symbol);
            }
            case TAG: {
                Tag tag = this.tagDecoder.decode(symbol);
                DataItem next = this.decodeNext();
                if (next == null) {
                    throw new CborException("Unexpected end of stream: tag without following data item.");
                }
                if (this.autoDecodeRationalNumbers && tag.getValue() == 30L) {
                    return this.decodeRationalNumber(next);
                }
                if (this.autoDecodeLanguageTaggedStrings && tag.getValue() == 38L) {
                    return this.decodeLanguageTaggedString(next);
                }
                DataItem itemToTag = next;
                while (itemToTag.hasTag()) {
                    itemToTag = itemToTag.getTag();
                }
                itemToTag.setTag(tag);
                return next;
            }
        }
        throw new CborException("Not implemented major type " + symbol);
    }

    private DataItem decodeLanguageTaggedString(DataItem dataItem) throws CborException {
        if (!(dataItem instanceof Array)) {
            throw new CborException("Error decoding LanguageTaggedString: not an array");
        }
        Array array = (Array)dataItem;
        if (array.getDataItems().size() != 2) {
            throw new CborException("Error decoding LanguageTaggedString: array size is not 2");
        }
        DataItem languageDataItem = array.getDataItems().get(0);
        if (!(languageDataItem instanceof UnicodeString)) {
            throw new CborException("Error decoding LanguageTaggedString: first data item is not an UnicodeString");
        }
        DataItem stringDataItem = array.getDataItems().get(1);
        if (!(stringDataItem instanceof UnicodeString)) {
            throw new CborException("Error decoding LanguageTaggedString: second data item is not an UnicodeString");
        }
        UnicodeString language = (UnicodeString)languageDataItem;
        UnicodeString string = (UnicodeString)stringDataItem;
        return new LanguageTaggedString(language, string);
    }

    private DataItem decodeRationalNumber(DataItem dataItem) throws CborException {
        if (!(dataItem instanceof Array)) {
            throw new CborException("Error decoding RationalNumber: not an array");
        }
        Array array = (Array)dataItem;
        if (array.getDataItems().size() != 2) {
            throw new CborException("Error decoding RationalNumber: array size is not 2");
        }
        DataItem numeratorDataItem = array.getDataItems().get(0);
        if (!(numeratorDataItem instanceof Number)) {
            throw new CborException("Error decoding RationalNumber: first data item is not a number");
        }
        DataItem denominatorDataItem = array.getDataItems().get(1);
        if (!(denominatorDataItem instanceof Number)) {
            throw new CborException("Error decoding RationalNumber: second data item is not a number");
        }
        Number numerator = (Number)numeratorDataItem;
        Number denominator = (Number)denominatorDataItem;
        return new RationalNumber(numerator, denominator);
    }

    public boolean isAutoDecodeInfinitiveArrays() {
        return this.autoDecodeInfinitiveArrays;
    }

    public void setAutoDecodeInfinitiveArrays(boolean autoDecodeInfinitiveArrays) {
        this.autoDecodeInfinitiveArrays = autoDecodeInfinitiveArrays;
    }

    public boolean isAutoDecodeInfinitiveMaps() {
        return this.autoDecodeInfinitiveMaps;
    }

    public void setAutoDecodeInfinitiveMaps(boolean autoDecodeInfinitiveMaps) {
        this.autoDecodeInfinitiveMaps = autoDecodeInfinitiveMaps;
    }

    public boolean isAutoDecodeInfinitiveByteStrings() {
        return this.autoDecodeInfinitiveByteStrings;
    }

    public void setAutoDecodeInfinitiveByteStrings(boolean autoDecodeInfinitiveByteStrings) {
        this.autoDecodeInfinitiveByteStrings = autoDecodeInfinitiveByteStrings;
    }

    public boolean isAutoDecodeInfinitiveUnicodeStrings() {
        return this.autoDecodeInfinitiveUnicodeStrings;
    }

    public void setAutoDecodeInfinitiveUnicodeStrings(boolean autoDecodeInfinitiveUnicodeStrings) {
        this.autoDecodeInfinitiveUnicodeStrings = autoDecodeInfinitiveUnicodeStrings;
    }

    public boolean isAutoDecodeRationalNumbers() {
        return this.autoDecodeRationalNumbers;
    }

    public void setAutoDecodeRationalNumbers(boolean autoDecodeRationalNumbers) {
        this.autoDecodeRationalNumbers = autoDecodeRationalNumbers;
    }

    public boolean isAutoDecodeLanguageTaggedStrings() {
        return this.autoDecodeLanguageTaggedStrings;
    }

    public void setAutoDecodeLanguageTaggedStrings(boolean autoDecodeLanguageTaggedStrings) {
        this.autoDecodeLanguageTaggedStrings = autoDecodeLanguageTaggedStrings;
    }

    public boolean isRejectDuplicateKeys() {
        return this.rejectDuplicateKeys;
    }

    public void setRejectDuplicateKeys(boolean rejectDuplicateKeys) {
        this.rejectDuplicateKeys = rejectDuplicateKeys;
    }

    public void setMaxPreallocationSize(int maxSize) {
        this.unsignedIntegerDecoder.setMaxPreallocationSize(maxSize);
        this.negativeIntegerDecoder.setMaxPreallocationSize(maxSize);
        this.byteStringDecoder.setMaxPreallocationSize(maxSize);
        this.unicodeStringDecoder.setMaxPreallocationSize(maxSize);
        this.arrayDecoder.setMaxPreallocationSize(maxSize);
        this.mapDecoder.setMaxPreallocationSize(maxSize);
        this.tagDecoder.setMaxPreallocationSize(maxSize);
        this.specialDecoder.setMaxPreallocationSize(maxSize);
    }
}

