/*
 * Decompiled with CFR 0.152.
 */
package shaded.co.nstant.in.cbor;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import shaded.co.nstant.in.cbor.builder.AbstractBuilder;
import shaded.co.nstant.in.cbor.builder.ArrayBuilder;
import shaded.co.nstant.in.cbor.builder.ByteStringBuilder;
import shaded.co.nstant.in.cbor.builder.MapBuilder;
import shaded.co.nstant.in.cbor.builder.UnicodeStringBuilder;
import shaded.co.nstant.in.cbor.model.Array;
import shaded.co.nstant.in.cbor.model.ByteString;
import shaded.co.nstant.in.cbor.model.DataItem;
import shaded.co.nstant.in.cbor.model.Map;
import shaded.co.nstant.in.cbor.model.UnicodeString;

public class CborBuilder
extends AbstractBuilder<CborBuilder> {
    private final LinkedList<DataItem> dataItems = new LinkedList();

    public CborBuilder() {
        super(null);
    }

    public CborBuilder reset() {
        this.dataItems.clear();
        return this;
    }

    public List<DataItem> build() {
        return this.dataItems;
    }

    public CborBuilder add(DataItem dataItem) {
        this.dataItems.add(dataItem);
        return this;
    }

    public CborBuilder add(long value) {
        this.add(this.convert(value));
        return this;
    }

    public CborBuilder add(BigInteger value) {
        this.add(this.convert(value));
        return this;
    }

    public CborBuilder add(boolean value) {
        this.add(this.convert(value));
        return this;
    }

    public CborBuilder add(float value) {
        this.add(this.convert(value));
        return this;
    }

    public CborBuilder add(double value) {
        this.add(this.convert(value));
        return this;
    }

    public CborBuilder add(byte[] bytes) {
        this.add(this.convert(bytes));
        return this;
    }

    public ByteStringBuilder<CborBuilder> startByteString() {
        return this.startByteString(null);
    }

    public ByteStringBuilder<CborBuilder> startByteString(byte[] bytes) {
        this.add(new ByteString(bytes).setChunked(true));
        return new ByteStringBuilder<CborBuilder>(this);
    }

    public CborBuilder add(String string) {
        this.add(this.convert(string));
        return this;
    }

    public UnicodeStringBuilder<CborBuilder> startString() {
        return this.startString(null);
    }

    public UnicodeStringBuilder<CborBuilder> startString(String string) {
        this.add(new UnicodeString(string).setChunked(true));
        return new UnicodeStringBuilder<CborBuilder>(this);
    }

    public CborBuilder addTag(long value) {
        this.add(this.tag(value));
        return this;
    }

    public CborBuilder tagged(long value) {
        DataItem item = this.dataItems.peekLast();
        if (item == null) {
            throw new IllegalStateException("Can't add a tag before adding an item");
        }
        item.getOuterTaggable().setTag(value);
        return this;
    }

    public ArrayBuilder<CborBuilder> startArray() {
        Array array = new Array();
        array.setChunked(true);
        this.add(array);
        return new ArrayBuilder<CborBuilder>(this, array);
    }

    public ArrayBuilder<CborBuilder> addArray() {
        Array array = new Array();
        this.add(array);
        return new ArrayBuilder<CborBuilder>(this, array);
    }

    public MapBuilder<CborBuilder> addMap() {
        Map map = new Map();
        this.add(map);
        return new MapBuilder<CborBuilder>(this, map);
    }

    public MapBuilder<CborBuilder> startMap() {
        Map map = new Map();
        map.setChunked(true);
        this.add(map);
        return new MapBuilder<CborBuilder>(this, map);
    }

    @Override
    protected void addChunk(DataItem dataItem) {
        this.add(dataItem);
    }
}

