/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.cip30;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import org.cardanofoundation.cip30.AddressFormat;
import org.cardanofoundation.cip30.CIP30Verifier;
import org.cardanofoundation.cip30.MessageFormat;
import org.cardanofoundation.cip30.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.bloxbean.cardano.client.address.util.AddressUtil;
import shaded.com.bloxbean.cardano.client.exception.AddressExcepion;
import shaded.com.bloxbean.cardano.client.util.HexUtil;
import shaded.javax.annotation.Nullable;
import shaded.javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Cip30VerificationResult {
    private static final Logger logger = LoggerFactory.getLogger(CIP30Verifier.class);
    private Optional<ValidationError> validationError = Optional.of(ValidationError.UNKNOWN);
    private Optional<byte[]> address = Optional.empty();
    private byte[] ed25519PublicKey;
    private byte[] ed25519Signature;
    private byte[] message;
    private byte[] cosePayload;

    private Cip30VerificationResult(Builder builder) {
        this.validationError = builder.validationError;
        this.address = builder.address;
        this.ed25519PublicKey = builder.ed25519PublicKey;
        this.ed25519Signature = builder.ed25519Signature;
        this.message = builder.message;
        this.cosePayload = builder.cosePayload;
    }

    public boolean isValid() {
        return this.validationError.isEmpty();
    }

    public Optional<ValidationError> getValidationError() {
        return this.validationError;
    }

    public Optional<byte[]> getAddress() {
        return this.address;
    }

    public Optional<String> getAddress(AddressFormat format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case AddressFormat.HEX -> this.address.map(HexUtil::encodeHexString);
            case AddressFormat.TEXT -> this.address.flatMap(addr -> {
                try {
                    return Optional.of(AddressUtil.bytesToAddress(addr));
                }
                catch (AddressExcepion e) {
                    logger.error("Error converting address to text", (Throwable)e);
                    return Optional.empty();
                }
            });
        };
    }

    @Nullable
    public byte[] getEd25519PublicKey() {
        return this.ed25519PublicKey;
    }

    @Nullable
    public byte[] getEd25519Signature() {
        return this.ed25519Signature;
    }

    @Nullable
    public byte[] getMessage() {
        return this.message;
    }

    @Nullable
    public byte[] getCosePayload() {
        return this.cosePayload;
    }

    public String getEd25519PublicKey(MessageFormat f, Charset c) {
        return this.formatter(this.ed25519PublicKey, f, c);
    }

    @Nullable
    public String getEd25519PublicKey(MessageFormat f) {
        return this.getEd25519PublicKey(f, StandardCharsets.UTF_8);
    }

    @Nullable
    public String getEd25519Signature(MessageFormat f, Charset c) {
        return this.formatter(this.ed25519Signature, f, c);
    }

    @Nullable
    public String getEd25519Signature(MessageFormat f) {
        return this.getEd25519Signature(f, StandardCharsets.UTF_8);
    }

    @Nullable
    public String getMessage(MessageFormat f, Charset c) {
        return this.formatter(this.message, f, c);
    }

    @Nullable
    public String getMessage(MessageFormat f) {
        return this.getMessage(f, StandardCharsets.UTF_8);
    }

    @Nullable
    public String getCosePayload(MessageFormat f) {
        return this.getCosePayload(f, StandardCharsets.UTF_8);
    }

    @Nullable
    public String getCosePayload(MessageFormat f, Charset c) {
        return this.formatter(this.cosePayload, f, c);
    }

    public static Cip30VerificationResult createInvalid(ValidationError error) {
        return Builder.newBuilder().validationError(error).build();
    }

    private String formatter(byte[] bytes, MessageFormat f, Charset c) {
        if (bytes == null) {
            return null;
        }
        if (f == null) {
            throw new IllegalArgumentException("format must be defined");
        }
        if (c == null) {
            throw new IllegalArgumentException("charset must be defined");
        }
        return switch (f) {
            default -> throw new IncompatibleClassChangeError();
            case MessageFormat.HEX -> HexUtil.encodeHexString(bytes);
            case MessageFormat.TEXT -> new String(bytes, c);
            case MessageFormat.BASE64 -> Base64.getEncoder().encodeToString(bytes);
        };
    }

    public String toString() {
        return "Cip30VerificationResult{valid=" + this.validationError.isEmpty() + ", validationError=" + this.validationError + ", address=" + this.address + ", ed25519PublicKey=" + this.ed25519PublicKey + ", ed25519Signature=" + this.ed25519Signature + ", message=" + this.message + ", cosePayload=" + this.cosePayload + "}";
    }

    public static class Builder {
        private Optional<ValidationError> validationError = Optional.of(ValidationError.UNKNOWN);
        private Optional<byte[]> address = Optional.empty();
        private byte[] ed25519PublicKey;
        private byte[] ed25519Signature;
        private byte[] message;
        private byte[] cosePayload;

        static Builder newBuilder() {
            return new Builder();
        }

        public Builder valid() {
            this.validationError = Optional.empty();
            return this;
        }

        public Builder validationError(ValidationError error) {
            Objects.requireNonNull(error, "validation error is required");
            this.validationError = Optional.of(error);
            return this;
        }

        public Builder address(byte[] address) {
            Objects.requireNonNull(address, "address is required");
            this.address = Optional.of(address);
            return this;
        }

        public Builder ed25519PublicKey(byte[] ed25519PublicKey) {
            Objects.requireNonNull(ed25519PublicKey, "public key is required");
            this.ed25519PublicKey = ed25519PublicKey;
            return this;
        }

        public Builder ed25519Signature(byte[] signature) {
            Objects.requireNonNull(signature, "signature is required");
            this.ed25519Signature = signature;
            return this;
        }

        public Builder message(byte[] message) {
            this.message = message;
            return this;
        }

        public Builder cosePayload(byte[] cosePayload) {
            Objects.requireNonNull(cosePayload, "cosePayload is required");
            this.cosePayload = cosePayload;
            return this;
        }

        public Cip30VerificationResult build() {
            return new Cip30VerificationResult(this);
        }
    }
}

